/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.ContainerCache;
import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheableContainerProcessor;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.extension.spring.Crane4jApplicationContext;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class SpringCacheableContainerProcessor
extends CacheableContainerProcessor {
    public SpringCacheableContainerProcessor(Crane4jApplicationContext configuration) {
        super((Crane4jGlobalConfiguration)configuration);
    }

    protected CacheDefinition getCacheDefinitionFromContainer(Container<Object> container) {
        CacheDefinition definition = super.getCacheDefinitionFromContainer(container);
        if (Objects.nonNull(definition)) {
            return definition;
        }
        ContainerCache annotation = this.findAnnotation(container);
        return Objects.isNull(annotation) ? null : new CacheDefinition.Impl(container.getNamespace(), annotation.cacheManager(), Long.valueOf(annotation.expirationTime()), annotation.timeUnit());
    }

    private @Nullable ContainerCache findAnnotation(Container<Object> container) {
        Crane4jApplicationContext context = (Crane4jApplicationContext)this.configuration;
        String beanName = context.getBeanNameByNamespace(container.getNamespace());
        if (Objects.nonNull(beanName)) {
            ApplicationContext applicationContext = context.getApplicationContext();
            return (ContainerCache)applicationContext.findAnnotationOnBean(beanName, ContainerCache.class);
        }
        Class containerClass = AopUtils.getTargetClass(container);
        return (ContainerCache)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)containerClass, ContainerCache.class);
    }
}

