/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.auto.SaTokenDaoByObjectFollowString;
import cn.dev33.satoken.util.SaFoxUtil;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RedissonClient;

public class SaTokenDaoForRedisson
implements SaTokenDaoByObjectFollowString,
SaTokenDao {
    public final RedissonClient redissonClient;

    public SaTokenDaoForRedisson(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public String get(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key);
        return (String)rBucket.get();
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RBucket bucket = this.redissonClient.getBucket(key);
            bucket.set((Object)value);
        } else {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync bucket = batch.getBucket(key);
            bucket.setAsync((Object)value);
            bucket.expireAsync(Duration.ofSeconds(timeout));
            batch.execute();
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.redissonClient.getBucket(key).delete();
    }

    public long getTimeout(String key) {
        RBucket rBucket = this.redissonClient.getBucket(key);
        long timeout = rBucket.remainTimeToLive();
        return timeout < 0L ? timeout : timeout / 1000L;
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        RBucket rBucket = this.redissonClient.getBucket(key);
        rBucket.expire(Duration.ofSeconds(timeout));
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Stream stream = this.redissonClient.getKeys().getKeysStreamByPattern(prefix + "*" + keyword + "*");
        List list = stream.collect(Collectors.toList());
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

