/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.server.netty;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.HttpRequestHandler;
import com.aizuda.snailjob.server.common.cache.CacheToken;
import com.aizuda.snailjob.server.common.dto.NettyHttpRequest;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Collection;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RequestHandlerActor")
@Scope(value="prototype")
public class NettyRequestHandlerActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRequestHandlerActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(NettyHttpRequest.class, nettyHttpRequest -> {
            String uri = nettyHttpRequest.getUri();
            if (StrUtil.isBlank((CharSequence)uri)) {
                SnailJobLog.LOCAL.error("uri can not be null", new Object[0]);
                return;
            }
            ChannelHandlerContext channelHandlerContext = nettyHttpRequest.getChannelHandlerContext();
            boolean keepAlive = nettyHttpRequest.isKeepAlive();
            HttpMethod method = nettyHttpRequest.getMethod();
            String content = nettyHttpRequest.getContent();
            HttpHeaders headers = nettyHttpRequest.getHeaders();
            SnailJobRpcResult result = null;
            try {
                result = this.doProcess(uri, content, method, headers);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("http request error. [{}]", new Object[]{nettyHttpRequest.getContent(), e});
                SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
                result = new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), e.getMessage(), null, retryRequest.getReqId());
            }
            finally {
                this.writeResponse(channelHandlerContext, keepAlive, JsonUtil.toJsonString((Object)result));
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private SnailJobRpcResult doProcess(String uri, String content, HttpMethod method, HttpHeaders headers) {
        String groupName = headers.get(HeadersEnum.GROUP_NAME.getKey());
        String namespace = headers.get(HeadersEnum.NAMESPACE.getKey());
        String token = headers.get(HeadersEnum.TOKEN.getKey());
        if (StrUtil.isBlank((CharSequence)token) || !CacheToken.get(groupName, namespace).equals(token)) {
            throw new SnailJobServerException("Token authentication failed. [namespace:{} groupName:{} token:{}]", namespace, groupName, token);
        }
        UrlBuilder builder = UrlBuilder.ofHttp((String)uri);
        Collection httpRequestHandlers = SnailSpringContext.getContext().getBeansOfType(HttpRequestHandler.class).values();
        for (HttpRequestHandler httpRequestHandler : httpRequestHandlers) {
            if (!httpRequestHandler.supports(builder.getPathStr()) || !method.name().equals(httpRequestHandler.method().name())) continue;
            return httpRequestHandler.doHandler(content, builder, headers);
        }
        throw new SnailJobServerException("No matching handler found. Path:[{}] method:[{}]", builder.getPathStr(), method.name());
    }

    private void writeResponse(ChannelHandlerContext ctx, boolean keepAlive, String responseJson) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)responseJson, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.writeAndFlush((Object)response);
    }
}

