/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.job;

import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.client.model.request.DispatchJobRequest;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.client.JobRpcClient;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.RealJobExecutorDTO;
import com.aizuda.snailjob.server.job.task.support.ClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackFactory;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealJobExecutorActor")
@Scope(value="prototype")
public class RequestClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestClientActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RealJobExecutorDTO.class, realJobExecutorDTO -> {
            try {
                this.doExecute((RealJobExecutorDTO)realJobExecutorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
        }).build();
    }

    private void doExecute(RealJobExecutorDTO realJobExecutorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode((String)realJobExecutorDTO.getGroupName(), (String)realJobExecutorDTO.getNamespaceId(), (String)realJobExecutorDTO.getClientId());
        if (Objects.isNull(registerNodeInfo)) {
            RequestClientActor.taskExecuteFailure(realJobExecutorDTO, "Client does not exist");
            JobLogMetaDTO jobLogMetaDTO = JobTaskConverter.INSTANCE.toJobLogDTO(realJobExecutorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            if (realJobExecutorDTO.getRetryStatus().booleanValue()) {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed, executing retry. Reason: No executable client. Retry count:[{}]. <|>{}<|>", new Object[]{realJobExecutorDTO.getTaskId(), realJobExecutorDTO.getRetryCount(), jobLogMetaDTO});
            } else {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed. Reason: No executable client <|>{}<|>", new Object[]{realJobExecutorDTO.getTaskId(), jobLogMetaDTO});
            }
            return;
        }
        DispatchJobRequest dispatchJobRequest = JobTaskConverter.INSTANCE.toDispatchJobRequest(realJobExecutorDTO);
        dispatchJobRequest.setRetry(realJobExecutorDTO.getRetryStatus().booleanValue());
        try {
            JobRpcClient rpcClient = this.buildRpcClient(registerNodeInfo, realJobExecutorDTO);
            Result<Boolean> dispatch = rpcClient.dispatch(dispatchJobRequest);
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue() && Objects.equals(dispatch.getData(), Boolean.TRUE)) {
                SnailJobLog.LOCAL.info("Task ID:[{}] Task scheduled successfully.", new Object[]{realJobExecutorDTO.getTaskId()});
            } else {
                ClientCallbackHandler clientCallback = ClientCallbackFactory.getClientCallback(realJobExecutorDTO.getTaskType());
                ClientCallbackContext context = JobTaskConverter.INSTANCE.toClientCallbackContext(realJobExecutorDTO);
                context.setTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
                context.setExecuteResult(ExecuteResult.failure(null, (String)dispatch.getMessage()));
                clientCallback.callback(context);
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            JobLogMetaDTO jobLogMetaDTO = JobTaskConverter.INSTANCE.toJobLogDTO(realJobExecutorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            if (realJobExecutorDTO.getRetryStatus().booleanValue()) {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed, executing retry. Retry count:[{}]. <|>{}<|>", new Object[]{jobLogMetaDTO.getTaskId(), realJobExecutorDTO.getRetryCount(), jobLogMetaDTO, throwable});
            } else {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed. <|>{}<|>", new Object[]{jobLogMetaDTO.getTaskId(), jobLogMetaDTO, throwable});
            }
            RequestClientActor.taskExecuteFailure(realJobExecutorDTO, throwable.getMessage());
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(dispatchJobRequest.getTaskBatchId()).reason(throwable.getMessage()).notifyScene(JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene()).build()));
        }
    }

    private JobRpcClient buildRpcClient(RegisterNodeInfo registerNodeInfo, RealJobExecutorDTO realJobExecutorDTO) {
        int maxRetryTimes = realJobExecutorDTO.getMaxRetryTimes();
        boolean retry = realJobExecutorDTO.getRetryStatus();
        return (JobRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).failRetry(maxRetryTimes > 0 && !retry).retryTimes(maxRetryTimes).retryInterval(realJobExecutorDTO.getRetryInterval().intValue()).retryListener((RetryListener)new JobExecutorRetryListener(realJobExecutorDTO)).client(JobRpcClient.class).build();
    }

    private static void taskExecuteFailure(RealJobExecutorDTO realJobExecutorDTO, String message) {
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(realJobExecutorDTO);
        jobExecutorResultDTO.setTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
        jobExecutorResultDTO.setMessage(message);
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    public static class JobExecutorRetryListener
    implements RetryListener {
        private final RealJobExecutorDTO realJobExecutorDTO;

        public JobExecutorRetryListener(RealJobExecutorDTO realJobExecutorDTO) {
            this.realJobExecutorDTO = realJobExecutorDTO;
        }

        public <V> void onRetry(Attempt<V> attempt) {
            if (attempt.hasException()) {
                SnailJobLog.LOCAL.error("Task scheduling failed. Task instance ID:[{}] Count:[{}]", new Object[]{this.realJobExecutorDTO.getTaskBatchId(), attempt.getAttemptNumber(), attempt.getExceptionCause()});
                ClientCallbackHandler clientCallback = ClientCallbackFactory.getClientCallback(this.realJobExecutorDTO.getTaskType());
                ClientCallbackContext context = JobTaskConverter.INSTANCE.toClientCallbackContext(this.realJobExecutorDTO);
                context.setTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
                context.setExecuteResult(ExecuteResult.failure(null, (String)"Network request failed"));
                clientCallback.callback(context);
            }
        }
    }
}

