/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.vo.RequestUpdateRetryStatusVO;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiUpdateRetryStatusRequestHandler
extends PostHttpRequestHandler {
    private final RetryMapper retryMapper;
    private final AccessTemplate accessTemplate;

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("update retry status:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        RequestUpdateRetryStatusVO updateRetryStatusVO = (RequestUpdateRetryStatusVO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), RequestUpdateRetryStatusVO.class);
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)updateRetryStatusVO.getRetryStatus());
        Assert.notNull((Object)retryStatusEnum, () -> new SnailJobServerException("Retry status error. [{}]", new Object[]{updateRetryStatusVO.getRetryStatus()}));
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)updateRetryStatusVO.getId());
        Assert.notNull((Object)retry, () -> new SnailJobServerException("Retry task not found:[{}].", new Object[]{retry.getId()}));
        retry.setRetryStatus(updateRetryStatusVO.getRetryStatus());
        if (RetryStatusEnum.RUNNING == retryStatusEnum) {
            RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retry.getGroupName(), retry.getSceneName(), retry.getNamespaceId());
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(retry.getRetryCount() + 1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
            retry.setNextTriggerAt(waitStrategy.computeTriggerTime(waitStrategyContext));
        }
        retry.setUpdateDt(LocalDateTime.now());
        Assert.isTrue((this.retryMapper.updateById((Object)retry) == 1 ? 1 : 0) != 0, () -> new SnailJobServerException("Update status of retry task failed:[{}].", new Object[]{retry.getId()}));
        return new SnailJobRpcResult((Object)true, retryRequest.getReqId());
    }

    public boolean supports(String path) {
        return "/api/retry/updateRetryStatus".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Generated
    public OpenApiUpdateRetryStatusRequestHandler(RetryMapper retryMapper, AccessTemplate accessTemplate) {
        this.retryMapper = retryMapper;
        this.accessTemplate = accessTemplate;
    }
}

