/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.afr.autoconfigure;

import com.cssw.afr.AfrNet;
import com.cssw.afr.autoconfigure.AfrProperties;
import com.cssw.afr.core.AfrApi;
import com.cssw.afr.core.AfrApiImpl;
import com.cssw.afr.core.dao.AfrDao;
import com.cssw.afr.core.dao.AfrDaoImpl;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={AfrProperties.class})
@ConditionalOnProperty(prefix="cssw.afr", name={"enabled"}, havingValue="true")
public class AfrAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AfrAutoConfiguration.class);
    private final AfrProperties afrProperties;

    @Bean
    @ConditionalOnMissingBean
    public AfrDao afrDao() {
        return new AfrDaoImpl(this.afrProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AfrApi afrApi(AfrDao afrDao) {
        return new AfrApiImpl(afrDao);
    }

    @PostConstruct
    public void postConstruct() {
        AfrNet.configure((String)this.afrProperties.getDetectorModelFilePath(), (String)this.afrProperties.getLandmarkerModelFilePath(), (String)this.afrProperties.getRecognizerModelFilePath());
        log.debug(" Auto Configuration 'Afr' completed initialization.");
    }

    public AfrAutoConfiguration(AfrProperties afrProperties) {
        this.afrProperties = afrProperties;
    }
}

