/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.afr.core;

import com.cssw.afr.AfrNet;
import com.cssw.afr.Rect;
import com.cssw.afr.core.AfrApi;
import com.cssw.afr.core.dao.AfrDao;
import com.cssw.afr.core.exception.GroupAlreadyExistsException;
import com.cssw.afr.core.exception.GroupNotExistsException;
import com.cssw.afr.core.exception.MultiFacesDetectedException;
import com.cssw.afr.core.exception.NoneFacesDetectedException;
import com.cssw.afr.core.exception.PersonAlreadyExistsException;
import com.cssw.afr.core.exception.PersonNotExistsException;
import com.cssw.afr.core.model.dto.Candidate;
import com.cssw.afr.core.model.dto.FaceRect;
import com.cssw.afr.core.model.dto.SearchResult;
import com.cssw.afr.core.model.entity.PersonDO;
import com.cssw.afr.core.model.req.DetectReq;
import com.cssw.afr.core.model.req.GroupCreateReq;
import com.cssw.afr.core.model.req.GroupDeleteReq;
import com.cssw.afr.core.model.req.PersonCreateReq;
import com.cssw.afr.core.model.req.PersonDeleteReq;
import com.cssw.afr.core.model.req.PersonUpdateReq;
import com.cssw.afr.core.model.req.SearchReq;
import com.cssw.afr.core.model.resp.DetectResp;
import com.cssw.afr.core.model.resp.SearchResp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfrApiImpl
implements AfrApi {
    private static final Logger log = LoggerFactory.getLogger(AfrApiImpl.class);
    private final AfrDao afrDao;

    @Override
    public DetectResp detect(DetectReq req) {
        List list = AfrNet.detect((String)req.getFilePath());
        ArrayList<FaceRect> rects = new ArrayList<FaceRect>();
        for (Rect li : list) {
            FaceRect rect = new FaceRect();
            rect.setX(li.getX());
            rect.setY(li.getY());
            rect.setWidth(li.getWidth());
            rect.setHeight(li.getHeight());
            rects.add(rect);
        }
        return DetectResp.builder().rects(rects).build();
    }

    @Override
    public void createGroup(GroupCreateReq req) {
        this.checkGroupAlreadyExists(req.getName());
        this.afrDao.createGroup(req.getName());
    }

    @Override
    public void deleteGroup(GroupDeleteReq req) {
        this.checkGroupExists(req.getName());
        this.afrDao.deleteGroup(req.getName());
    }

    @Override
    public void createPerson(PersonCreateReq req) {
        this.checkGroupExists(req.getGroupName());
        this.checkPersonAlreadyExists(req.getGroupName(), req.getId());
        List rects = AfrNet.detect((String)req.getFilePath());
        this.checkNoneFaces(rects);
        this.checkMultiFaces(rects);
        float[] features = AfrNet.extract((String)req.getFilePath(), (Rect)((Rect)rects.get(0)));
        this.afrDao.createPerson(req.getGroupName(), req.getId(), features);
    }

    @Override
    public void updatePerson(PersonUpdateReq req) {
        this.checkGroupExists(req.getGroupName());
        this.checkPersonExists(req.getGroupName(), req.getId());
        List rects = AfrNet.detect((String)req.getFilePath());
        this.checkNoneFaces(rects);
        this.checkMultiFaces(rects);
        float[] features = AfrNet.extract((String)req.getFilePath(), (Rect)((Rect)rects.get(0)));
        this.afrDao.updatePerson(req.getGroupName(), req.getId(), features);
    }

    @Override
    public void deletePerson(PersonDeleteReq req) {
        this.checkGroupExists(req.getGroupName());
        this.checkPersonExists(req.getGroupName(), req.getId());
        this.afrDao.deletePerson(req.getGroupName(), req.getId());
    }

    @Override
    public SearchResp search(SearchReq req) {
        this.checkGroupExists(req.getGroupName());
        List rects = AfrNet.detect((String)req.getFilePath());
        this.checkNoneFaces(rects);
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (Rect rect : rects) {
            float[] features = AfrNet.extract((String)req.getFilePath(), (Rect)rect);
            List<PersonDO> list = this.afrDao.searchPerson(req.getGroupName(), features);
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            for (PersonDO li : list) {
                Candidate candidate = new Candidate();
                candidate.setId(li.getId());
                candidate.setScore(li.getScore());
                candidates.add(candidate);
            }
            FaceRect faceRect = new FaceRect();
            faceRect.setX(rect.getX());
            faceRect.setY(rect.getY());
            faceRect.setWidth(rect.getWidth());
            faceRect.setHeight(rect.getHeight());
            results.add(SearchResult.builder().candidates(candidates).rect(faceRect).build());
        }
        return SearchResp.builder().results(results).build();
    }

    private void checkGroupAlreadyExists(String groupName) {
        if (this.afrDao.containsGroup(groupName).booleanValue()) {
            throw new GroupAlreadyExistsException();
        }
    }

    private void checkGroupExists(String groupName) {
        if (!this.afrDao.containsGroup(groupName).booleanValue()) {
            throw new GroupNotExistsException();
        }
    }

    private void checkPersonAlreadyExists(String groupName, String id) {
        if (this.afrDao.containsPerson(groupName, id).booleanValue()) {
            throw new PersonAlreadyExistsException();
        }
    }

    private void checkPersonExists(String groupName, String id) {
        if (!this.afrDao.containsPerson(groupName, id).booleanValue()) {
            throw new PersonNotExistsException();
        }
    }

    private void checkMultiFaces(List<Rect> rects) {
        if (rects.size() > 1) {
            throw new MultiFacesDetectedException();
        }
    }

    private void checkNoneFaces(List<Rect> rects) {
        if (rects.isEmpty()) {
            throw new NoneFacesDetectedException();
        }
    }

    public AfrApiImpl(AfrDao afrDao) {
        this.afrDao = afrDao;
    }
}

