/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.afr.core.dao;

import com.cssw.afr.autoconfigure.AfrProperties;
import com.cssw.afr.core.dao.AfrDao;
import com.cssw.afr.core.model.entity.FaceDO;
import com.cssw.afr.core.model.entity.PersonDO;
import com.cssw.afr.core.util.GsonUtil;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.database.request.CreateDatabaseReq;
import io.milvus.v2.service.database.response.ListDatabasesResp;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.FloatVec;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AfrDaoImpl
implements AfrDao,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AfrDaoImpl.class);
    private final AfrProperties properties;
    private final MilvusClientV2 milvus;

    public AfrDaoImpl(AfrProperties properties) {
        this.properties = properties;
        this.milvus = new MilvusClientV2(ConnectConfig.builder().uri(properties.getUrl()).username(properties.getUsername()).password(properties.getPassword()).build());
    }

    @Override
    public void createGroup(String groupName) {
        this.milvus.createCollection(CreateCollectionReq.builder().databaseName(this.properties.getDbName()).collectionName(groupName).collectionSchema(MilvusClientV2.CreateSchema().addField(AddFieldReq.builder().fieldName("id").dataType(DataType.VarChar).maxLength(Integer.valueOf(50)).isPrimaryKey(Boolean.valueOf(true)).build()).addField(AddFieldReq.builder().fieldName("features").dataType(DataType.FloatVector).dimension(Integer.valueOf(1024)).build())).indexParam(IndexParam.builder().fieldName("features").indexType(IndexParam.IndexType.AUTOINDEX).metricType(IndexParam.MetricType.COSINE).build()).build());
    }

    @Override
    public void deleteGroup(String groupName) {
        this.milvus.dropCollection(DropCollectionReq.builder().databaseName(this.properties.getDbName()).collectionName(groupName).build());
    }

    @Override
    public Boolean containsGroup(String groupName) {
        Boolean exists = this.milvus.hasCollection(HasCollectionReq.builder().databaseName(this.properties.getDbName()).collectionName(groupName).build());
        return exists;
    }

    @Override
    public void createPerson(String group, String id, float[] features) {
        this.milvus.insert(InsertReq.builder().databaseName(this.properties.getDbName()).collectionName(group).data(GsonUtil.toJsonObjectList(FaceDO.builder().id(id).features(features).build())).build());
    }

    @Override
    public void updatePerson(String group, String id, float[] features) {
        this.deletePerson(group, id);
        this.createPerson(group, id, features);
    }

    @Override
    public void deletePerson(String group, String id) {
        this.milvus.delete(DeleteReq.builder().databaseName(this.properties.getDbName()).collectionName(group).ids(Collections.singletonList(id)).build());
    }

    @Override
    public Boolean containsPerson(String group, String id) {
        GetResp resp = this.milvus.get(GetReq.builder().databaseName(this.properties.getDbName()).collectionName(group).ids(Collections.singletonList(id)).build());
        return !resp.getGetResults().isEmpty();
    }

    @Override
    public List<PersonDO> searchPerson(String group, float[] features) {
        SearchResp resp = this.milvus.search(SearchReq.builder().databaseName(this.properties.getDbName()).collectionName(group).data(Collections.singletonList(new FloatVec(features))).annsField("features").topK(3).build());
        ArrayList<PersonDO> list = new ArrayList<PersonDO>();
        List searchResults = (List)resp.getSearchResults().get(0);
        if (searchResults != null && !searchResults.isEmpty()) {
            for (SearchResp.SearchResult searchResult : searchResults) {
                list.add(PersonDO.builder().id(String.valueOf(searchResult.getId())).score(searchResult.getScore()).build());
            }
        }
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            ListDatabasesResp listDatabasesResp = this.milvus.listDatabases();
            if (!listDatabasesResp.getDatabaseNames().contains(this.properties.getDbName())) {
                this.milvus.createDatabase(CreateDatabaseReq.builder().databaseName(this.properties.getDbName()).build());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

