/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.captcha.behavior.autoconfigure;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.anji.captcha.service.CaptchaService;
import com.anji.captcha.service.impl.CaptchaServiceFactory;
import com.anji.captcha.util.ImageUtils;
import com.cssw.bootx.captcha.behavior.autoconfigure.BehaviorCaptchaProperties;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@AutoConfiguration
@EnableConfigurationProperties(value={BehaviorCaptchaProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.captcha.behavior", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BehaviorCaptchaAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BehaviorCaptchaAutoConfiguration.class);

    @Bean
    @DependsOn(value={"captchaCacheService"})
    @ConditionalOnMissingBean
    public CaptchaService captchaService(BehaviorCaptchaProperties properties) {
        Properties config = new Properties();
        config.put("captcha.cacheType", properties.getCacheType().name().toLowerCase());
        config.put("captcha.water.mark", properties.getWaterMark());
        config.put("captcha.font.type", properties.getFontType());
        config.put("captcha.type", properties.getType().getCodeValue());
        config.put("captcha.interference.options", properties.getInterferenceOptions());
        config.put("captcha.captchaOriginalPath.jigsaw", CharSequenceUtil.emptyIfNull((CharSequence)properties.getJigsawBaseMapPath()));
        config.put("captcha.captchaOriginalPath.pic-click", CharSequenceUtil.emptyIfNull((CharSequence)properties.getPicClickBaseMapPath()));
        config.put("captcha.slip.offset", properties.getSlipOffset());
        config.put("captcha.aes.status", String.valueOf(properties.getEnableAes()));
        config.put("captcha.water.font", properties.getWaterFont());
        config.put("captcha.cache.number", properties.getCacheNumber());
        config.put("captcha.timing.clear", properties.getTimingClear());
        config.put("captcha.history.data.clear.enable", properties.getHistoryDataClearEnable());
        config.put("captcha.req.frequency.limit.enable", properties.getReqFrequencyLimitEnable());
        config.put("captcha.req.get.lock.limit", properties.getReqGetLockLimit());
        config.put("captcha.req.get.lock.seconds", properties.getReqGetLockSeconds());
        config.put("captcha.req.get.minute.limit", properties.getReqGetMinuteLimit());
        config.put("captcha.req.check.minute.limit", properties.getReqCheckMinuteLimit());
        config.put("captcha.req.verify.minute.limit", properties.getReqVerifyMinuteLimit());
        config.put("captcha.font.size", properties.getFontSize());
        config.put("captcha.font.style", properties.getFontStyle());
        config.put("captcha.word.count", (Object)4);
        if (CharSequenceUtil.startWith((CharSequence)properties.getJigsawBaseMapPath(), (CharSequence)"classpath:") || CharSequenceUtil.startWith((CharSequence)properties.getPicClickBaseMapPath(), (CharSequence)"classpath:")) {
            config.put("captcha.init.original", (Object)true);
            BehaviorCaptchaAutoConfiguration.initializeBaseMap(properties.getJigsawBaseMapPath(), properties.getPicClickBaseMapPath());
        }
        return CaptchaServiceFactory.getInstance((Properties)config);
    }

    private static void initializeBaseMap(String jigsaw, String picClick) {
        ImageUtils.cacheBootImage(BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(jigsaw + "/original/*.png"), BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(jigsaw + "/slidingBlock/*.png"), BehaviorCaptchaAutoConfiguration.getResourcesImagesFile(picClick + "/*.png"));
    }

    private static Map<String, String> getResourcesImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(path)) {
                String imageName = resource.getFilename();
                byte[] imageValue = FileUtil.readBytes((File)resource.getFile());
                imgMap.put(imageName, Base64.encode((byte[])imageValue));
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u8def\u5f84\u4e3a [{}] \u4e0b\u7684\u56fe\u7247\u6587\u4ef6\u5931\u8d25", (Object)path, (Object)e);
        }
        return imgMap;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Captcha-Behavior' completed initialization.");
    }
}

