/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.captcha.behavior.autoconfigure.cache;

import cn.hutool.extra.spring.SpringUtil;
import com.anji.captcha.service.CaptchaCacheService;
import com.anji.captcha.service.impl.CaptchaCacheServiceMemImpl;
import com.anji.captcha.service.impl.CaptchaServiceFactory;
import com.cssw.bootx.cache.redisson.autoconfigure.RedissonAutoConfiguration;
import com.cssw.bootx.captcha.behavior.autoconfigure.cache.BehaviorCaptchaCacheServiceImpl;
import com.cssw.bootx.captcha.behavior.enums.StorageType;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.redisson.client.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;

@AutoConfiguration
public class BehaviorCaptchaCacheAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BehaviorCaptchaCacheAutoConfiguration.class);

    @AutoConfiguration
    @ConditionalOnProperty(name={"bootx-starter.captcha.behavior.cache-type"}, havingValue="custom")
    public static class Custom {
        @Bean
        @ConditionalOnMissingBean
        public CaptchaCacheService captchaCacheService() {
            if (log.isErrorEnabled()) {
                log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(CaptchaCacheService.class));
            }
            throw new NoSuchBeanDefinitionException(CaptchaCacheService.class);
        }

        @PostConstruct
        public void postConstruct() {
            CaptchaServiceFactory.cacheService.put(StorageType.CUSTOM.name().toLowerCase(), (CaptchaCacheService)SpringUtil.getBean(CaptchaCacheService.class));
            log.debug("[Bootx Starter] - Auto Configuration 'Captcha-Behavior-Cache-Custom' completed initialization.");
        }
    }

    @AutoConfiguration(before={RedissonAutoConfiguration.class})
    @ConditionalOnClass(value={RedisClient.class})
    @ConditionalOnMissingBean(value={CaptchaCacheService.class})
    @ConditionalOnProperty(name={"bootx-starter.captcha.behavior.cache-type"}, havingValue="redis")
    public static class Redis {
        @Bean
        public CaptchaCacheService captchaCacheService() {
            return new BehaviorCaptchaCacheServiceImpl();
        }

        @PostConstruct
        public void postConstruct() {
            CaptchaServiceFactory.cacheService.put(StorageType.REDIS.name().toLowerCase(), this.captchaCacheService());
            log.debug("[Bootx Starter] - Auto Configuration 'Captcha-Behavior-Cache-Redis' completed initialization.");
        }
    }

    @AutoConfiguration
    @ConditionalOnMissingBean(value={CaptchaCacheService.class})
    @ConditionalOnProperty(name={"bootx-starter.captcha.behavior.cache-type"}, havingValue="default", matchIfMissing=true)
    public static class Default {
        @Bean
        public CaptchaCacheService captchaCacheService() {
            return new CaptchaCacheServiceMemImpl();
        }

        @PostConstruct
        public void postConstruct() {
            CaptchaServiceFactory.cacheService.put(StorageType.DEFAULT.name().toLowerCase(), this.captchaCacheService());
            log.debug("[Bootx Starter] - Auto Configuration 'Captcha-Behavior-Cache-Default' completed initialization.");
        }
    }
}

