/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.autoconfigure.threadpool;

import com.cssw.bootx.core.autoconfigure.threadpool.ThreadPoolExtensionProperties;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.task.ThreadPoolTaskSchedulerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(proxyBeanMethods=false)
@EnableScheduling
@ConditionalOnProperty(prefix="spring.task.scheduling.extension", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class TaskSchedulingConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSchedulingConfiguration.class);

    @Bean
    public ThreadPoolTaskSchedulerCustomizer threadPoolTaskSchedulerCustomizer(ThreadPoolExtensionProperties properties) {
        return executor -> executor.setRejectedExecutionHandler(properties.getScheduling().getRejectedPolicy().getRejectedExecutionHandler());
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'TaskScheduler' completed initialization.");
    }
}

