/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.autoconfigure.threadpool;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ThreadPoolExecutorRejectedPolicy {
    ABORT{

        @Override
        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return new ThreadPoolExecutor.AbortPolicy();
        }
    }
    ,
    CALLER_RUNS{

        @Override
        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
    }
    ,
    DISCARD{

        @Override
        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return new ThreadPoolExecutor.DiscardPolicy();
        }
    }
    ,
    DISCARD_OLDEST{

        @Override
        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return new ThreadPoolExecutor.DiscardOldestPolicy();
        }
    };


    public abstract RejectedExecutionHandler getRejectedExecutionHandler();
}

