/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.enums;

import java.io.Serializable;
import java.util.Objects;

public interface BaseEnum<T extends Serializable> {
    public T getValue();

    public String getDescription();

    default public String getColor() {
        return null;
    }

    public static <E extends Enum<E>, T> E getByValue(T value, Class<E> clazz) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!Objects.equals(((BaseEnum)((Object)e)).getValue(), value)) continue;
            return (E)e;
        }
        return null;
    }

    public static <E extends Enum<E>> E getByDescription(String description, Class<?> clazz) {
        for (Object e : clazz.getEnumConstants()) {
            BaseEnum baseEnum;
            if (!(e instanceof BaseEnum) || !Objects.equals((baseEnum = (BaseEnum)e).getDescription(), description)) continue;
            return (E)((Enum)((Object)baseEnum));
        }
        return null;
    }

    public static <E extends Enum<E>, T> boolean isValidValue(T value, Class<E> clazz) {
        return BaseEnum.getByValue(value, clazz) != null;
    }
}

