/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public static void printException(Runnable runnable, Throwable throwable) {
        if (throwable == null && runnable instanceof Future) {
            Future future = (Future)((Object)runnable);
            try {
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException e) {
                throwable = e;
            }
            catch (ExecutionException e) {
                throwable = e.getCause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (throwable != null) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    public static <T> T exToNull(ExSupplier<T> exSupplier) {
        return ExceptionUtils.exToDefault(exSupplier, null);
    }

    public static <T> T exToNull(ExSupplier<T> supplier, Consumer<Exception> exConsumer) {
        return ExceptionUtils.exToDefault(supplier, null, exConsumer);
    }

    public static String exToBlank(ExSupplier<String> exSupplier) {
        return ExceptionUtils.exToDefault(exSupplier, "");
    }

    public static <T> T exToDefault(ExSupplier<T> exSupplier, T defaultValue) {
        return ExceptionUtils.exToDefault(exSupplier, defaultValue, null);
    }

    public static <T, E extends Exception> T exToThrow(ExSupplier<T> exSupplier, Function<Exception, E> exceptionMapper) throws E {
        try {
            return exSupplier.get();
        }
        catch (Exception e) {
            throw (Exception)exceptionMapper.apply(e);
        }
    }

    public static <T> T exToDefault(ExSupplier<T> exSupplier, T defaultValue, Consumer<Exception> exConsumer) {
        try {
            return exSupplier.get();
        }
        catch (Exception e) {
            if (exConsumer != null) {
                exConsumer.accept(e);
            }
            return defaultValue;
        }
    }

    @Generated
    private ExceptionUtils() {
    }

    public static interface ExSupplier<T> {
        public T get() throws Exception;
    }
}

