/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.URLUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static File upload(MultipartFile multipartFile, String filePath, boolean isKeepOriginalFilename) {
        String originalFilename = multipartFile.getOriginalFilename();
        String extensionName = FileNameUtil.extName((String)originalFilename);
        String fileName = isKeepOriginalFilename ? "%s-%s.%s".formatted(FileNameUtil.getPrefix((String)originalFilename), DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmssSSS"), extensionName) : "%s.%s".formatted(IdUtil.fastSimpleUUID(), extensionName);
        try {
            String pathname = filePath + fileName;
            File dest = new File(pathname).getCanonicalFile();
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                log.error("Create upload file parent path failed.");
            }
            multipartFile.transferTo(dest);
            return dest;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void download(HttpServletResponse response, File file) throws IOException {
        FileUploadUtils.download(response, new FileInputStream(file), file.getName());
    }

    public static void download(HttpServletResponse response, InputStream inputStream, String fileName) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLUtil.encode((String)fileName));
        try (InputStream inputStream2 = inputStream;
             ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentLengthLong(inputStream.transferTo((OutputStream)outputStream));
        }
    }

    @Generated
    private FileUploadUtils() {
    }
}

