/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.http.HtmlUtil;
import java.util.LinkedHashSet;
import java.util.Objects;
import lombok.Generated;
import net.dreamlu.mica.ip2region.core.Ip2regionSearcher;
import net.dreamlu.mica.ip2region.core.IpInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpv4Address(String ip) {
        if (IpUtils.isInnerIpv4(ip)) {
            return "\u5185\u7f51IP";
        }
        Ip2regionSearcher ip2regionSearcher = (Ip2regionSearcher)SpringUtil.getBean(Ip2regionSearcher.class);
        IpInfo ipInfo = ip2regionSearcher.memorySearch(ip);
        if (ipInfo == null) {
            return null;
        }
        LinkedHashSet regionSet = CollUtil.newLinkedHashSet((Object[])new String[]{ipInfo.getCountry(), ipInfo.getRegion(), ipInfo.getProvince(), ipInfo.getCity(), ipInfo.getIsp()});
        regionSet.removeIf(Objects::isNull);
        return String.join((CharSequence)"|", regionSet);
    }

    public static boolean isInnerIpv4(String ip) {
        return NetUtil.isInnerIP((String)("0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : HtmlUtil.cleanHtmlTag((String)ip)));
    }

    @Generated
    private IpUtils() {
    }
}

