/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.hutool.json.JSONUtil;
import com.cssw.bootx.core.wrapper.RepeatReadRequestWrapper;
import com.cssw.bootx.core.wrapper.RepeatReadResponseWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriUtils;

public class ServletUtils
extends JakartaServletUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    public static String getBrowser(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return ServletUtils.getBrowser(request.getHeader("User-Agent"));
    }

    public static String getBrowser(String userAgentString) {
        try {
            UserAgent userAgent = UserAgentUtil.parse((String)userAgentString);
            if (userAgent == null || userAgent.getBrowser() == null) {
                return null;
            }
            String browserName = userAgent.getBrowser().getName();
            String version = userAgent.getVersion();
            return CharSequenceUtil.isBlank((CharSequence)version) ? browserName : browserName + " " + version;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOs(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return ServletUtils.getOs(request.getHeader("User-Agent"));
    }

    public static String getOs(String userAgentString) {
        try {
            UserAgent userAgent = UserAgentUtil.parse((String)userAgentString);
            if (userAgent == null || userAgent.getOs() == null) {
                return null;
            }
            return userAgent.getOs().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRequestMethod() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? request.getMethod() : null;
    }

    public static String getRequestParameter(String name) {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? request.getParameter(name) : null;
    }

    public static String getRequestIp() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : null;
    }

    public static Map<String, String> getRequestHeaders() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? ServletUtils.getHeaderMap((HttpServletRequest)request) : Collections.emptyMap();
    }

    public static URI getRequestUrl() {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return null;
        }
        String queryString = request.getQueryString();
        if (CharSequenceUtil.isBlank((CharSequence)queryString)) {
            return URI.create(request.getRequestURL().toString());
        }
        try {
            StringBuilder urlBuilder = ServletUtils.appendQueryString(queryString);
            return new URI(urlBuilder.toString());
        }
        catch (URISyntaxException e) {
            String encoded = UriUtils.encodeQuery((String)queryString, (Charset)StandardCharsets.UTF_8);
            StringBuilder urlBuilder = ServletUtils.appendQueryString(encoded);
            return URI.create(urlBuilder.toString());
        }
    }

    public static String getRequestPath() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? request.getRequestURI() : null;
    }

    public static String getRequestBody() {
        RepeatReadRequestWrapper wrapper;
        HttpServletRequest request = ServletUtils.getRequest();
        if (request instanceof RepeatReadRequestWrapper && !(wrapper = (RepeatReadRequestWrapper)request).isMultipartContent((ServletRequest)request)) {
            String body = JakartaServletUtil.getBody((ServletRequest)request);
            return JSONUtil.isTypeJSON((String)body) ? body : null;
        }
        return null;
    }

    public static Map<String, Object> getRequestParams() {
        String body = ServletUtils.getRequestBody();
        return CharSequenceUtil.isNotBlank((CharSequence)body) && JSONUtil.isTypeJSON((String)body) ? (Map)JSONUtil.toBean((String)body, Map.class) : Collections.unmodifiableMap(JakartaServletUtil.getParamMap((ServletRequest)((ServletRequest)Objects.requireNonNull(ServletUtils.getRequest()))));
    }

    public static int getResponseStatus() {
        HttpServletResponse response = ServletUtils.getResponse();
        return response != null ? response.getStatus() : -1;
    }

    public static Map<String, String> getResponseHeaders() {
        HttpServletResponse response = ServletUtils.getResponse();
        if (response == null) {
            return Collections.emptyMap();
        }
        Collection headerNames = response.getHeaderNames();
        HashMap headerMap = MapUtil.newHashMap((int)headerNames.size(), (boolean)true);
        for (String name : headerNames) {
            headerMap.put(name, response.getHeader(name));
        }
        return headerMap;
    }

    public static String getResponseBody() {
        RepeatReadResponseWrapper wrapper;
        HttpServletResponse response = ServletUtils.getResponse();
        if (response instanceof RepeatReadResponseWrapper && !(wrapper = (RepeatReadResponseWrapper)response).isStreamingResponse()) {
            String body = wrapper.getResponseContent();
            return JSONUtil.isTypeJSON((String)body) ? body : null;
        }
        return null;
    }

    public static Map<String, Object> getResponseParams() {
        String body = ServletUtils.getResponseBody();
        return CharSequenceUtil.isNotBlank((CharSequence)body) && JSONUtil.isTypeJSON((String)body) ? (Map)JSONUtil.toBean((String)body, Map.class) : null;
    }

    public static HttpSession getSession() {
        HttpServletRequest request = ServletUtils.getRequest();
        return request != null ? request.getSession() : null;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = ServletUtils.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = ServletUtils.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getResponse();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        try {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            return (ServletRequestAttributes)attributes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeJSON(HttpServletResponse response, String data) {
        ServletUtils.write((HttpServletResponse)response, (String)data, (String)"application/json");
    }

    private static StringBuilder appendQueryString(String queryString) {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return new StringBuilder();
        }
        return new StringBuilder().append(request.getRequestURL()).append("?").append(queryString);
    }

    @Generated
    private ServletUtils() {
    }
}

