/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import com.cssw.bootx.core.util.CollUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class TreeUtils
extends TreeUtil {
    public static <T, K> List<Tree<K>> build(List<T> list, NodeParser<T, K> nodeParser) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Tree<K>>(0);
        }
        Object k = ReflectUtil.invoke(list.get(0), (String)CharSequenceUtil.genGetter((CharSequence)"parentId"), (Object[])new Object[0]);
        return TreeUtil.build(list, (Object)k, (TreeNodeConfig)TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, K> List<Tree<K>> build(List<T> list, K parentId, NodeParser<T, K> nodeParser) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Tree<K>>(0);
        }
        return TreeUtil.build(list, parentId, (TreeNodeConfig)TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, K> List<Tree<K>> build(List<T> list, K parentId, TreeNodeConfig treeNodeConfig, NodeParser<T, K> nodeParser) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Tree<K>>(0);
        }
        return TreeUtil.build(list, parentId, (TreeNodeConfig)treeNodeConfig, nodeParser);
    }

    public static <T, K> List<Tree<K>> buildMultiRoot(List<T> list, Function<T, K> getId, Function<T, K> getParentId, NodeParser<T, K> parser) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Tree<K>>(0);
        }
        Set<K> rootParentIds = CollUtils.mapToSet(list, getParentId);
        rootParentIds.removeAll(CollUtils.mapToSet(list, getId));
        return rootParentIds.stream().flatMap(rootParentId -> TreeUtil.build((List)list, (Object)rootParentId, (NodeParser)parser).stream()).collect(Collectors.toList());
    }

    public static <T, K> List<Tree<K>> buildMultiRoot(List<T> list, Function<T, K> getId, Function<T, K> getParentId, TreeNodeConfig treeNodeConfig, NodeParser<T, K> parser) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<Tree<K>>(0);
        }
        Set<K> rootParentIds = CollUtils.mapToSet(list, getParentId);
        rootParentIds.removeAll(CollUtils.mapToSet(list, getId));
        return rootParentIds.stream().flatMap(rootParentId -> TreeUtil.build((List)list, (Object)rootParentId, (TreeNodeConfig)treeNodeConfig, (NodeParser)parser).stream()).collect(Collectors.toList());
    }

    public static <K> List<Tree<K>> getLeafNodes(List<Tree<K>> nodes) {
        if (CollUtil.isEmpty(nodes)) {
            return new ArrayList<Tree<K>>(0);
        }
        return nodes.stream().flatMap(TreeUtils::extractLeafNodes).collect(Collectors.toList());
    }

    private static <K> Stream<Tree<K>> extractLeafNodes(Tree<K> node) {
        if (!node.hasChild()) {
            return Stream.of(node);
        }
        return node.getChildren().stream().flatMap(TreeUtils::extractLeafNodes);
    }

    @Generated
    private TreeUtils() {
    }
}

