/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.core.wrapper;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.StreamUtils;

public class RepeatReadRequestWrapper
extends HttpServletRequestWrapper {
    private final FastByteArrayOutputStream cachedContent;
    private ContentCachingInputStream contentCachingInputStream;
    private final String characterEncoding;

    public RepeatReadRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.characterEncoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : StandardCharsets.UTF_8.name();
        int contentLength = super.getRequest().getContentLength();
        FastByteArrayOutputStream fastByteArrayOutputStream = this.cachedContent = contentLength > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
        if (!this.isMultipartContent((ServletRequest)request)) {
            if (this.isFormRequest()) {
                this.writeRequestParametersToCachedContent();
            } else {
                StreamUtils.copy((InputStream)request.getInputStream(), (OutputStream)this.cachedContent);
            }
            this.contentCachingInputStream = new ContentCachingInputStream(this.cachedContent.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInputStream getInputStream() throws IOException {
        if (this.isMultipartContent(super.getRequest())) {
            return super.getRequest().getInputStream();
        }
        RepeatReadRequestWrapper repeatReadRequestWrapper = this;
        synchronized (repeatReadRequestWrapper) {
            this.contentCachingInputStream.reset();
            return this.contentCachingInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getReader() throws IOException {
        if (this.isMultipartContent(super.getRequest())) {
            return super.getRequest().getReader();
        }
        RepeatReadRequestWrapper repeatReadRequestWrapper = this;
        synchronized (repeatReadRequestWrapper) {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
    }

    private void writeRequestParametersToCachedContent() {
        try {
            if (this.cachedContent.size() == 0) {
                Map form = super.getParameterMap();
                Iterator nameIterator = form.keySet().iterator();
                while (nameIterator.hasNext()) {
                    String name = (String)nameIterator.next();
                    List<String> values = Arrays.asList((String[])form.get(name));
                    Iterator<String> valueIterator = values.iterator();
                    while (valueIterator.hasNext()) {
                        String value = valueIterator.next();
                        this.cachedContent.write(URLEncoder.encode(name, this.characterEncoding).getBytes());
                        if (value == null) continue;
                        this.cachedContent.write("=".getBytes());
                        this.cachedContent.write(URLEncoder.encode(value, this.characterEncoding).getBytes());
                        if (!valueIterator.hasNext()) continue;
                        this.cachedContent.write("&".getBytes());
                    }
                    if (!nameIterator.hasNext()) continue;
                    this.cachedContent.write("&".getBytes());
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write request parameters to cached content", ex);
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentAsString() {
        return this.cachedContent.toString(Charset.forName(this.getCharacterEncoding()));
    }

    public FastByteArrayOutputStream getCachedContent() {
        return this.cachedContent;
    }

    public boolean isMultipartContent(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    private boolean isFormRequest() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }

    private static class ContentCachingInputStream
    extends ServletInputStream {
        private final InputStream delegate;

        public ContentCachingInputStream(byte[] body) {
            this.delegate = new ByteArrayInputStream(body);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

