/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.data.enums;

import com.cssw.bootx.data.function.ISqlFunction;
import java.io.Serializable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DatabaseType implements ISqlFunction
{
    MYSQL("MySQL"){

        @Override
        public String findInSet(Serializable value, String set) {
            return "find_in_set('%s', %s) <> 0".formatted(value, set);
        }
    }
    ,
    POSTGRE_SQL("PostgreSQL"){

        @Override
        public String findInSet(Serializable value, String set) {
            return "(select position(',%s,' in ','||%s||',')) <> 0".formatted(value, set);
        }
    };

    private final String database;

    private DatabaseType(String database) {
        this.database = database;
    }

    public static DatabaseType get(String database) {
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!databaseType.database.equalsIgnoreCase(database)) continue;
            return databaseType;
        }
        return null;
    }

    public String getDatabase() {
        return this.database;
    }
}

