/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.data.mybatisplus.service.impl;

import cn.hutool.core.util.ClassUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.MapperProxyMetadata;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.MybatisUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.reflect.GenericTypeUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.cssw.bootx.core.util.ReflectUtils;
import com.cssw.bootx.core.util.validation.CheckUtils;
import com.cssw.bootx.data.mybatisplus.service.IService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    @Autowired
    protected M baseMapper;
    private Class<T> entityClass;
    private Class<M> mapperClass;
    private List<Field> entityFields;
    private volatile SqlSessionFactory sqlSessionFactory;
    private final Log innerLog = LogFactory.getLog(this.getClass());

    public boolean saveOrUpdate(T entity) {
        return this.getBaseMapper().insertOrUpdate(entity);
    }

    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        return (T)this.getBaseMapper().selectOne(queryWrapper, throwEx);
    }

    public Optional<T> getOneOpt(Wrapper<T> queryWrapper, boolean throwEx) {
        return Optional.ofNullable(this.getBaseMapper().selectOne(queryWrapper, throwEx));
    }

    public Map<String, Object> getMap(Wrapper<T> queryWrapper) {
        return (Map)SqlHelper.getObject((Log)this.innerLog, (List)this.getBaseMapper().selectMaps(queryWrapper));
    }

    public <V> V getObj(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        return (V)SqlHelper.getObject((Log)this.innerLog, (List)this.listObjs(queryWrapper, mapper));
    }

    protected <E> boolean executeBatch(Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.executeBatch((SqlSessionFactory)this.getSqlSessionFactory(), (Log)this.innerLog, list, (int)batchSize, consumer);
    }

    protected <E> boolean executeBatch(Collection<E> list, BiConsumer<SqlSession, E> consumer) {
        return this.executeBatch(list, 1000, consumer);
    }

    public boolean removeById(Serializable id, boolean useFill) {
        return SqlHelper.retBool((Integer)this.getBaseMapper().deleteById((Object)id, useFill));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch((SqlSessionFactory)this.getSqlSessionFactory(), this.getMapperClass(), (Log)this.innerLog, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    public T getById(Serializable id) {
        return this.getById(id, true);
    }

    public M getBaseMapper() {
        Assert.notNull(this.baseMapper, (String)"baseMapper can not be null", (Object[])new Object[0]);
        return this.baseMapper;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = GenericTypeUtils.resolveTypeArguments(this.getMapperClass(), BaseMapper.class)[0];
        }
        return this.entityClass;
    }

    public Class<M> getMapperClass() {
        if (this.mapperClass == null) {
            MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this.getBaseMapper());
            this.mapperClass = mapperProxyMetadata.getMapperInterface();
        }
        return this.mapperClass;
    }

    public List<Field> getEntityFields() {
        if (this.entityFields == null) {
            this.entityFields = ReflectUtils.getNonStaticFields(this.getEntityClass());
        }
        return this.entityFields;
    }

    protected SqlSessionFactory getSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this.getBaseMapper());
            this.sqlSessionFactory = MybatisUtils.getSqlSessionFactory((SqlSession)mapperProxyMetadata.getSqlSession());
        }
        return this.sqlSessionFactory;
    }

    protected String getSqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.getMapperClass(), (SqlMethod)sqlMethod);
    }

    protected T getById(Serializable id, boolean isCheckExists) {
        Object entity = this.baseMapper.selectById(id);
        if (isCheckExists) {
            CheckUtils.throwIfNotExists((Object)entity, (String)ClassUtil.getClassName(this.getEntityClass(), (boolean)true), (String)"ID", (Object)id);
        }
        return (T)entity;
    }
}

