/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.api.filter;

import cn.hutool.core.util.RandomUtil;
import com.cssw.bootx.encrypt.util.EncryptUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class ResponseBodyEncryptWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final ServletOutputStream servletOutputStream = this.getOutputStream();
    private final PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.byteArrayOutputStream));

    public ResponseBodyEncryptWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public PrintWriter getWriter() {
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public void reset() {
        this.byteArrayOutputStream.reset();
    }

    public byte[] getResponseData() throws IOException {
        this.flushBuffer();
        return this.byteArrayOutputStream.toByteArray();
    }

    public String getContent() throws IOException {
        this.flushBuffer();
        return this.byteArrayOutputStream.toString();
    }

    public String getEncryptContent(HttpServletResponse response, String publicKey, String secretKeyHeader) throws IOException {
        String aesSecretKey = RandomUtil.randomString((int)32);
        String secretKeyByBase64 = EncryptUtils.encodeByBase64((String)aesSecretKey);
        String secretKeyByRsa = EncryptUtils.encryptByRsa((String)secretKeyByBase64, (String)publicKey);
        response.addHeader("Access-Control-Expose-Headers", secretKeyHeader);
        response.setHeader(secretKeyHeader, secretKeyByRsa);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setCharacterEncoding("UTF-8");
        return EncryptUtils.encryptByAes((String)this.getContent(), (String)aesSecretKey);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                ResponseBodyEncryptWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                ResponseBodyEncryptWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ResponseBodyEncryptWrapper.this.byteArrayOutputStream.write(b, off, len);
            }
        };
    }
}

