/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public class EncryptUtils {
    public static String encodeByBase64(String data) {
        return Base64.encode((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String decodeByBase64(String data) {
        return Base64.decodeStr((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String encryptByAes(String data, String password) {
        if (CharSequenceUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptBase64(data, StandardCharsets.UTF_8);
    }

    public static String decryptByAes(String data, String password) {
        if (CharSequenceUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static String encryptByRsa(String data, String publicKey) {
        if (CharSequenceUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        RSA rsa = SecureUtil.rsa(null, (String)publicKey);
        return rsa.encryptBase64(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String decryptByRsa(String data, String privateKey) {
        if (CharSequenceUtil.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u79c1\u94a5\u8fdb\u884c\u89e3\u5bc6");
        }
        RSA rsa = SecureUtil.rsa((String)privateKey, null);
        return rsa.decryptStr(data, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    @Generated
    private EncryptUtils() {
    }
}

