/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.excel.util;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.cssw.bootx.excel.annotation.ExcelExport;
import com.cssw.bootx.excel.annotation.ExcelImport;
import com.cssw.bootx.excel.model.ExcelClassField;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    public static final String ROW_MERGE = "row_merge";
    public static final String COLUMN_MERGE = "column_merge";
    private static final String XLSX = ".xlsx";
    private static final String XLS = ".xls";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String ROW_NUM = "rowNum";
    private static final String ROW_DATA = "rowData";
    private static final String ROW_TIPS = "rowTips";
    private static final int CELL_OTHER = 0;
    private static final int CELL_ROW_MERGE = 1;
    private static final int CELL_COLUMN_MERGE = 2;
    private static final int IMG_HEIGHT = 30;
    private static final int IMG_WIDTH = 30;
    private static final char LEAN_LINE = '/';
    private static final int BYTES_DEFAULT_LENGTH = 10240;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();

    public static <T> List<T> readFile(File file, Class<T> clazz) throws Exception {
        JSONArray array = ExcelUtils.readFile(file);
        return ExcelUtils.getBeanList(array, clazz);
    }

    public static <T> List<T> readMultipartFile(MultipartFile mFile, Class<T> clazz) throws Exception {
        JSONArray array = ExcelUtils.readMultipartFile(mFile);
        return ExcelUtils.getBeanList(array, clazz);
    }

    public static JSONArray readFile(File file) throws Exception {
        return ExcelUtils.readExcel(null, file);
    }

    public static JSONArray readMultipartFile(MultipartFile mFile) throws Exception {
        return ExcelUtils.readExcel(mFile, null);
    }

    public static Map<String, JSONArray> readFileManySheet(File file) throws Exception {
        return ExcelUtils.readExcelManySheet(null, file);
    }

    public static Map<String, JSONArray> readFileManySheet(MultipartFile file) throws Exception {
        return ExcelUtils.readExcelManySheet(file, null);
    }

    private static <T> List<T> getBeanList(JSONArray array, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        HashMap<Integer, String> uniqueMap = new HashMap<Integer, String>(16);
        for (int i = 0; i < array.size(); ++i) {
            list.add(ExcelUtils.getBean(clazz, array.getJSONObject((Object)i), uniqueMap));
        }
        return list;
    }

    private static <T> T getBean(Class<T> c, JSONObject obj, Map<Integer, String> uniqueMap) throws Exception {
        T t = c.newInstance();
        Field[] fields = c.getDeclaredFields();
        ArrayList<String> errMsgList = new ArrayList<String>();
        boolean hasRowTipsField = false;
        StringBuilder uniqueBuilder = new StringBuilder();
        int rowNum = 0;
        for (Field field : fields) {
            if (field.getName().equals(ROW_NUM)) {
                rowNum = obj.getInt((Object)ROW_NUM);
                field.setAccessible(true);
                field.set(t, rowNum);
                continue;
            }
            if (field.getName().equals(ROW_TIPS)) {
                hasRowTipsField = true;
                continue;
            }
            if (field.getName().equals(ROW_DATA)) {
                field.setAccessible(true);
                field.set(t, obj.toString());
                continue;
            }
            ExcelUtils.setFieldValue(t, field, obj, uniqueBuilder, errMsgList);
        }
        if (!uniqueBuilder.isEmpty()) {
            if (uniqueMap.containsValue(uniqueBuilder.toString())) {
                Set<Integer> rowNumKeys = uniqueMap.keySet();
                for (Integer num : rowNumKeys) {
                    if (!uniqueMap.get(num).contentEquals(uniqueBuilder)) continue;
                    errMsgList.add(String.format("\u6570\u636e\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25,(%s)\u4e0e\u7b2c%s\u884c\u91cd\u590d)", uniqueBuilder, num));
                }
            } else {
                uniqueMap.put(rowNum, uniqueBuilder.toString());
            }
        }
        if (errMsgList.isEmpty() && !hasRowTipsField) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        int size = errMsgList.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sb.append((String)errMsgList.get(i));
                continue;
            }
            sb.append((String)errMsgList.get(i)).append(";");
        }
        for (Field field : fields) {
            if (!field.getName().equals(ROW_TIPS)) continue;
            field.setAccessible(true);
            field.set(t, sb.toString());
        }
        return t;
    }

    private static <T> void setFieldValue(T t, Field field, JSONObject obj, StringBuilder uniqueBuilder, List<String> errMsgList) {
        LinkedHashMap<String, String> kvMap;
        int maxLength;
        ExcelImport annotation = field.getAnnotation(ExcelImport.class);
        if (annotation == null) {
            return;
        }
        String cname = annotation.value();
        if (cname.trim().isEmpty()) {
            return;
        }
        String val = null;
        if (obj.containsKey((Object)cname)) {
            val = ExcelUtils.getString(obj.getStr((Object)cname));
        }
        if (val == null) {
            return;
        }
        field.setAccessible(true);
        boolean require = annotation.required();
        if (require && val.isEmpty()) {
            errMsgList.add(String.format("[%s]\u4e0d\u80fd\u4e3a\u7a7a", cname));
            return;
        }
        boolean unique = annotation.unique();
        if (unique) {
            if (!uniqueBuilder.isEmpty()) {
                uniqueBuilder.append("--").append(val);
            } else {
                uniqueBuilder.append(val);
            }
        }
        if ((maxLength = annotation.maxLength()) > 0 && val.length() > maxLength) {
            errMsgList.add(String.format("[%s]\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26(\u5f53\u524d%s\u4e2a\u5b57\u7b26)", cname, maxLength, val.length()));
        }
        if (!(kvMap = ExcelUtils.getKvMap(annotation.kv())).isEmpty()) {
            boolean isMatch = false;
            for (String key : kvMap.keySet()) {
                if (!kvMap.get(key).equals(val)) continue;
                val = key;
                isMatch = true;
                break;
            }
            if (!isMatch) {
                errMsgList.add(String.format("[%s]\u7684\u503c\u4e0d\u6b63\u786e(\u5f53\u524d\u503c\u4e3a%s)", cname, val));
                return;
            }
        }
        String fieldClassName = field.getType().getSimpleName();
        try {
            if ("String".equalsIgnoreCase(fieldClassName)) {
                field.set(t, val);
            } else if ("boolean".equalsIgnoreCase(fieldClassName)) {
                field.set(t, Boolean.valueOf(val));
            } else if ("int".equalsIgnoreCase(fieldClassName) || "Integer".equals(fieldClassName)) {
                try {
                    field.set(t, Integer.valueOf(val));
                }
                catch (NumberFormatException e) {
                    errMsgList.add(String.format("[%s]\u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e(\u5f53\u524d\u503c\u4e3a%s)", cname, val));
                }
            } else if ("double".equalsIgnoreCase(fieldClassName)) {
                field.set(t, Double.valueOf(val));
            } else if ("long".equalsIgnoreCase(fieldClassName)) {
                field.set(t, Long.valueOf(val));
            } else if ("BigDecimal".equalsIgnoreCase(fieldClassName)) {
                field.set(t, new BigDecimal(val));
            } else if ("Date".equalsIgnoreCase(fieldClassName)) {
                try {
                    field.set(t, new SimpleDateFormat(DATE_FORMAT).parse(val));
                }
                catch (Exception e) {
                    field.set(t, new SimpleDateFormat("yyyy-MM-dd").parse(val));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, JSONArray> readExcelManySheet(MultipartFile mFile, File file) throws IOException {
        Workbook book = ExcelUtils.getWorkbook(mFile, file);
        if (book == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, JSONArray> map = new LinkedHashMap<String, JSONArray>();
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            Sheet sheet = book.getSheetAt(i);
            JSONArray arr = ExcelUtils.readSheet(sheet);
            map.put(sheet.getSheetName(), arr);
        }
        book.close();
        return map;
    }

    private static JSONArray readExcel(MultipartFile mFile, File file) throws IOException {
        Workbook book = ExcelUtils.getWorkbook(mFile, file);
        if (book == null) {
            return new JSONArray();
        }
        JSONArray array = ExcelUtils.readSheet(book.getSheetAt(0));
        book.close();
        return array;
    }

    private static Workbook getWorkbook(MultipartFile mFile, File file) throws IOException {
        XSSFWorkbook book;
        String fileName;
        InputStream in;
        boolean fileNotExist;
        boolean bl = fileNotExist = file == null || !file.exists();
        if (mFile == null && fileNotExist) {
            return null;
        }
        if (mFile != null) {
            in = mFile.getInputStream();
            fileName = ExcelUtils.getString(mFile.getOriginalFilename()).toLowerCase();
        } else {
            in = new FileInputStream(file);
            fileName = file.getName().toLowerCase();
        }
        if (fileName.endsWith(XLSX)) {
            book = new XSSFWorkbook(in);
        } else if (fileName.endsWith(XLS)) {
            POIFSFileSystem poifsFileSystem = new POIFSFileSystem(in);
            book = new HSSFWorkbook(poifsFileSystem);
        } else {
            return null;
        }
        in.close();
        return book;
    }

    private static JSONArray readSheet(Sheet sheet) {
        int rowStart = sheet.getFirstRowNum();
        int rowEnd = sheet.getLastRowNum();
        Row headRow = sheet.getRow(rowStart);
        if (headRow == null) {
            return new JSONArray();
        }
        int cellStart = headRow.getFirstCellNum();
        short cellEnd = headRow.getLastCellNum();
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        for (int j = cellStart; j < cellEnd; ++j) {
            String val = ExcelUtils.getCellValue(headRow.getCell(j));
            if (val == null || val.trim().isEmpty()) continue;
            keyMap.put(j, val);
        }
        if (keyMap.isEmpty()) {
            return (JSONArray)Collections.emptyList();
        }
        JSONArray array = new JSONArray();
        if (rowStart == rowEnd) {
            JSONObject obj = new JSONObject();
            obj.putOnce(ROW_NUM, (Object)1);
            Iterator iterator = keyMap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                obj.set((String)keyMap.get(i), (Object)"");
            }
            array.add((Object)obj);
            return array;
        }
        for (int i = rowStart + 1; i <= rowEnd; ++i) {
            Row eachRow = sheet.getRow(i);
            JSONObject obj = new JSONObject();
            obj.set(ROW_NUM, (Object)(i + 1));
            StringBuilder sb = new StringBuilder();
            for (int k = cellStart; k < cellEnd; ++k) {
                if (eachRow == null) continue;
                String val = ExcelUtils.getCellValue(eachRow.getCell(k));
                sb.append(val);
                obj.set((String)keyMap.get(k), (Object)val);
            }
            if (sb.isEmpty()) continue;
            array.add((Object)obj);
        }
        return array;
    }

    private static String getCellValue(Cell cell) {
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            String val = cell.getStringCellValue();
            if (val == null || val.trim().isEmpty()) {
                return "";
            }
            return val.trim();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            String s = "" + cell.getNumericCellValue();
            if (Pattern.matches(".*\\.0*", s)) {
                return s.split("\\.")[0];
            }
            return s;
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return "" + cell.getBooleanCellValue();
        }
        return cell.getCellFormula();
    }

    public static <T> void exportTemplate(HttpServletResponse response, String fileName, Class<T> clazz) {
        ExcelUtils.exportTemplate(response, fileName, fileName, clazz, false);
    }

    public static <T> void exportTemplate(HttpServletResponse response, String fileName, String sheetName, Class<T> clazz) {
        ExcelUtils.exportTemplate(response, fileName, sheetName, clazz, false);
    }

    public static <T> void exportTemplate(HttpServletResponse response, String fileName, Class<T> clazz, boolean isContainExample) {
        ExcelUtils.exportTemplate(response, fileName, fileName, clazz, isContainExample);
    }

    public static <T> void exportTemplate(HttpServletResponse response, String fileName, String sheetName, Class<T> clazz, boolean isContainExample) {
        List<ExcelClassField> headFieldList = ExcelUtils.getExcelClassFieldList(clazz);
        ArrayList<List<Object>> sheetDataList = new ArrayList<List<Object>>();
        ArrayList<String> headList = new ArrayList<String>();
        ArrayList<Object> exampleList = new ArrayList<Object>();
        LinkedHashMap<Integer, List<String>> selectMap = new LinkedHashMap<Integer, List<String>>();
        for (int i = 0; i < headFieldList.size(); ++i) {
            ExcelClassField each = headFieldList.get(i);
            headList.add(each.getName());
            exampleList.add(each.getExample());
            LinkedHashMap<String, String> kvMap = each.getKvMap();
            if (kvMap == null || kvMap.isEmpty()) continue;
            selectMap.put(i, new ArrayList<String>(kvMap.values()));
        }
        sheetDataList.add(headList);
        if (isContainExample) {
            sheetDataList.add(exampleList);
        }
        ExcelUtils.export(response, fileName, sheetName, sheetDataList, selectMap);
    }

    private static <T> List<ExcelClassField> getExcelClassFieldList(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        boolean hasExportAnnotation = false;
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Integer> sortList = new ArrayList<Integer>();
        for (Field field : fields) {
            int sort;
            ExcelClassField cf = ExcelUtils.getExcelClassField(field);
            if (cf.getHasAnnotation() == 1) {
                hasExportAnnotation = true;
            }
            if (map.containsKey(sort = cf.getSort())) {
                ((List)map.get(sort)).add(cf);
                continue;
            }
            ArrayList<ExcelClassField> list = new ArrayList<ExcelClassField>();
            list.add(cf);
            sortList.add(sort);
            map.put(sort, list);
        }
        Collections.sort(sortList);
        ArrayList<ExcelClassField> headFieldList = new ArrayList<ExcelClassField>();
        if (hasExportAnnotation) {
            for (Integer sort : sortList) {
                for (ExcelClassField cf : (List)map.get(sort)) {
                    if (cf.getHasAnnotation() != 1) continue;
                    headFieldList.add(cf);
                }
            }
        } else {
            headFieldList.addAll((Collection)map.get(0));
        }
        return headFieldList;
    }

    private static ExcelClassField getExcelClassField(Field field) {
        ExcelClassField cf = new ExcelClassField();
        String fieldName = field.getName();
        cf.setFieldName(fieldName);
        ExcelExport annotation = field.getAnnotation(ExcelExport.class);
        if (annotation == null) {
            cf.setHasAnnotation(0);
            cf.setName(fieldName);
            cf.setSort(0);
            return cf;
        }
        cf.setHasAnnotation(1);
        cf.setName(annotation.value());
        String example = ExcelUtils.getString(annotation.example());
        if (!example.isEmpty()) {
            if (ExcelUtils.isNumeric(example) && example.length() < 8) {
                cf.setExample(Double.valueOf(example));
            } else {
                cf.setExample(example);
            }
        } else {
            cf.setExample("");
        }
        cf.setSort(annotation.sort());
        String kv = ExcelUtils.getString(annotation.kv());
        cf.setKvMap(ExcelUtils.getKvMap(kv));
        return cf;
    }

    private static LinkedHashMap<String, String> getKvMap(String kv) {
        String[] kvs;
        LinkedHashMap<String, String> kvMap = new LinkedHashMap<String, String>();
        if (kv.isEmpty()) {
            return kvMap;
        }
        for (String each : kvs = kv.split(";")) {
            String[] eachKv = ExcelUtils.getString(each).split("-");
            if (eachKv.length != 2) continue;
            String k = eachKv[0];
            String v = eachKv[1];
            if (k.isEmpty() || v.isEmpty()) continue;
            kvMap.put(k, v);
        }
        return kvMap;
    }

    public static void exportFile(File file, List<List<Object>> sheetData) {
        if (file == null) {
            System.out.println("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            return;
        }
        if (sheetData == null) {
            sheetData = new ArrayList<List<Object>>();
        }
        HashMap<String, List<List<Object>>> map = new HashMap<String, List<List<Object>>>();
        map.put(file.getName(), sheetData);
        ExcelUtils.export(null, file, file.getName(), map, null);
    }

    public static <T> File exportFile(String filePath, String fileName, List<T> list) throws IOException {
        File file = ExcelUtils.getFile(filePath, fileName);
        List<List<Object>> sheetData = ExcelUtils.getSheetData(list);
        ExcelUtils.exportFile(file, sheetData);
        return file;
    }

    private static File getFile(String filePath, String fileName) throws IOException {
        boolean result;
        Object fileFullPath;
        String dirPath = ExcelUtils.getString(filePath);
        if (dirPath.isEmpty()) {
            fileFullPath = fileName;
        } else {
            boolean mkdirs;
            File dirFile = new File(dirPath);
            if (!dirFile.exists() && !(mkdirs = dirFile.mkdirs())) {
                return null;
            }
            fileFullPath = dirPath.endsWith(String.valueOf('/')) ? dirPath + fileName + XLSX : dirPath + "/" + fileName + XLSX;
        }
        System.out.println((String)fileFullPath);
        File file = new File((String)fileFullPath);
        if (!file.exists() && !(result = file.createNewFile())) {
            return null;
        }
        return file;
    }

    private static <T> List<List<Object>> getSheetData(List<T> list) {
        List<ExcelClassField> excelClassFieldList = ExcelUtils.getExcelClassFieldList(list.get(0).getClass());
        ArrayList<String> headFieldList = new ArrayList<String>();
        ArrayList<String> headList = new ArrayList<String>();
        HashMap<String, ExcelClassField> headFieldMap = new HashMap<String, ExcelClassField>();
        for (ExcelClassField each : excelClassFieldList) {
            String fieldName = each.getFieldName();
            headFieldList.add(fieldName);
            headFieldMap.put(fieldName, each);
            headList.add(each.getName());
        }
        ArrayList<List<Object>> sheetDataList = new ArrayList<List<Object>>();
        sheetDataList.add(headList);
        for (T t : list) {
            Map<String, Object> fieldDataMap = ExcelUtils.getFieldDataMap(t);
            Set<String> fieldDataKeys = fieldDataMap.keySet();
            ArrayList<Object> rowList = new ArrayList<Object>();
            for (String headField : headFieldList) {
                if (!fieldDataKeys.contains(headField)) continue;
                Object data = fieldDataMap.get(headField);
                if (data == null) {
                    rowList.add("");
                    continue;
                }
                ExcelClassField cf = (ExcelClassField)headFieldMap.get(headField);
                LinkedHashMap<String, String> kvMap = cf.getKvMap();
                if (kvMap == null || kvMap.isEmpty()) {
                    rowList.add(data);
                    continue;
                }
                String val = kvMap.get(data.toString());
                if (ExcelUtils.isNumeric(val)) {
                    rowList.add(Double.valueOf(val));
                    continue;
                }
                rowList.add(val);
            }
            sheetDataList.add(rowList);
        }
        return sheetDataList;
    }

    private static <T> Map<String, Object> getFieldDataMap(T t) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = t.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                String fieldName = field.getName();
                field.setAccessible(true);
                Object object = field.get(t);
                map.put(fieldName, object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void exportEmpty(HttpServletResponse response, String fileName) {
        ArrayList<List<Object>> sheetDataList = new ArrayList<List<Object>>();
        ArrayList<String> headList = new ArrayList<String>();
        headList.add("\u5bfc\u51fa\u65e0\u6570\u636e");
        sheetDataList.add(headList);
        ExcelUtils.export(response, fileName, sheetDataList);
    }

    public static void export(HttpServletResponse response, String fileName, List<List<Object>> sheetDataList) {
        ExcelUtils.export(response, fileName, fileName, sheetDataList, null);
    }

    public static void exportManySheet(HttpServletResponse response, String fileName, Map<String, List<List<Object>>> sheetMap) {
        ExcelUtils.export(response, null, fileName, sheetMap, null);
    }

    public static void export(HttpServletResponse response, String fileName, String sheetName, List<List<Object>> sheetDataList) {
        ExcelUtils.export(response, fileName, sheetName, sheetDataList, null);
    }

    public static void export(HttpServletResponse response, String fileName, String sheetName, List<List<Object>> sheetDataList, Map<Integer, List<String>> selectMap) {
        HashMap<String, List<List<Object>>> map = new HashMap<String, List<List<Object>>>();
        map.put(sheetName, sheetDataList);
        ExcelUtils.export(response, null, fileName, map, selectMap);
    }

    public static <T, K> void export(HttpServletResponse response, String fileName, List<T> list, Class<K> template) {
        boolean lisIsEmpty;
        boolean bl = lisIsEmpty = list == null || list.isEmpty();
        if (template == null && lisIsEmpty) {
            ExcelUtils.exportEmpty(response, fileName);
            return;
        }
        if (lisIsEmpty) {
            ExcelUtils.exportTemplate(response, fileName, template);
            return;
        }
        List<List<Object>> sheetDataList = ExcelUtils.getSheetData(list);
        ExcelUtils.export(response, fileName, sheetDataList);
    }

    public static void export(HttpServletResponse response, String fileName, List<List<Object>> sheetDataList, Map<Integer, List<String>> selectMap) {
        ExcelUtils.export(response, fileName, fileName, sheetDataList, selectMap);
    }

    private static void export(HttpServletResponse response, File file, String fileName, Map<String, List<List<Object>>> sheetMap, Map<Integer, List<String>> selectMap) {
        SXSSFWorkbook book = new SXSSFWorkbook();
        Set<Map.Entry<String, List<List<Object>>>> entries = sheetMap.entrySet();
        for (Map.Entry<String, List<List<Object>>> entry : entries) {
            List<List<Object>> sheetDataList = entry.getValue();
            SXSSFSheet sheet = book.createSheet(entry.getKey());
            Drawing patriarch = sheet.createDrawingPatriarch();
            CellStyle headStyle = book.createCellStyle();
            headStyle.setFillForegroundColor(IndexedColors.GREY_80_PERCENT.index);
            headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            CellStyle rowStyle = book.createCellStyle();
            rowStyle.setAlignment(HorizontalAlignment.CENTER);
            rowStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            sheet.setDefaultColumnWidth(15);
            int rowLength = sheetDataList.size();
            int columnLength = sheetDataList.get(0).size();
            int[][] mergeArray = new int[rowLength][columnLength];
            for (int i = 0; i < sheetDataList.size(); ++i) {
                Row row = sheet.createRow(i);
                List<Object> rowList = sheetDataList.get(i);
                for (int j = 0; j < rowList.size(); ++j) {
                    Object o = rowList.get(j);
                    int v = 0;
                    if (o instanceof URL) {
                        ExcelUtils.setCellPicture(book, row, patriarch, i, j, (URL)o);
                    } else {
                        Cell cell = row.createCell(j);
                        v = i == 0 ? ExcelUtils.setCellValue(cell, o, headStyle) : ExcelUtils.setCellValue(cell, o, rowStyle);
                    }
                    mergeArray[i][j] = v;
                }
            }
            ExcelUtils.mergeCells((Sheet)sheet, mergeArray);
            ExcelUtils.setSelect((Sheet)sheet, selectMap);
        }
        if (response != null) {
            try {
                ExcelUtils.write(response, book, fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                ByteArrayOutputStream ops = new ByteArrayOutputStream();
                book.write((OutputStream)ops);
                fos.write(ops.toByteArray());
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void mergeCells(Sheet sheet, int[][] mergeArray) {
        for (int x = 0; x < mergeArray.length; ++x) {
            int[] arr = mergeArray[x];
            boolean merge = false;
            int y1 = 0;
            int y2 = 0;
            for (int y = 0; y < arr.length; ++y) {
                int value = arr[y];
                if (value == 2) {
                    if (!merge) {
                        y1 = y;
                    }
                    y2 = y;
                    merge = true;
                    continue;
                }
                merge = false;
                if (y1 > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(x, x, y1 - 1, y2));
                }
                y1 = 0;
                y2 = 0;
            }
            if (y1 <= 0) continue;
            sheet.addMergedRegion(new CellRangeAddress(x, x, y1 - 1, y2));
        }
        int xLen = mergeArray.length;
        int yLen = mergeArray[0].length;
        for (int y = 0; y < yLen; ++y) {
            boolean merge = false;
            int x1 = 0;
            int x2 = 0;
            for (int x = 0; x < xLen; ++x) {
                int value = mergeArray[x][y];
                if (value == 1) {
                    if (!merge) {
                        x1 = x;
                    }
                    x2 = x;
                    merge = true;
                    continue;
                }
                merge = false;
                if (x1 > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(x1 - 1, x2, y, y));
                }
                x1 = 0;
                x2 = 0;
            }
            if (x1 <= 0) continue;
            sheet.addMergedRegion(new CellRangeAddress(x1 - 1, x2, y, y));
        }
    }

    private static void write(HttpServletResponse response, SXSSFWorkbook book, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String name = new String(fileName.getBytes("GBK"), "ISO8859_1") + XLSX;
        response.addHeader("Content-Disposition", "attachment;filename=" + name);
        ServletOutputStream out = response.getOutputStream();
        book.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private static int setCellValue(Cell cell, Object o, CellStyle style) {
        cell.setCellStyle(style);
        if (o == null) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue("");
            return 0;
        }
        if (o instanceof String) {
            String s = o.toString();
            if (ExcelUtils.isNumeric(s) && s.length() < 8) {
                cell.setCellType(CellType.NUMERIC);
                cell.setCellValue(Double.parseDouble(s));
                return 0;
            }
            cell.setCellType(CellType.STRING);
            cell.setCellValue(s);
            if (s.equals(ROW_MERGE)) {
                return 1;
            }
            if (s.equals(COLUMN_MERGE)) {
                return 2;
            }
            return 0;
        }
        if (o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof Float) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(Double.parseDouble(o.toString()));
            return 0;
        }
        if (o instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(((Boolean)o).booleanValue());
            return 0;
        }
        if (o instanceof BigDecimal) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(((BigDecimal)o).setScale(3, RoundingMode.HALF_UP).doubleValue());
            return 0;
        }
        if (o instanceof Date) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(ExcelUtils.formatDate((Date)o));
            return 0;
        }
        cell.setCellType(CellType.STRING);
        cell.setCellValue(o.toString());
        return 0;
    }

    private static void setCellPicture(SXSSFWorkbook wb, Row sr, Drawing<?> patriarch, int x, int y, URL url) {
        sr.setHeight((short)900);
        try (InputStream is = url.openStream();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int rc;
            byte[] buff = new byte[10240];
            while ((rc = is.read(buff, 0, 10240)) > 0) {
                outputStream.write(buff, 0, rc);
            }
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, y, x, y + 1, x + 1);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
            patriarch.createPicture((ClientAnchor)anchor, wb.addPicture(outputStream.toByteArray(), 5));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(date);
    }

    private static void setSelect(Sheet sheet, Map<Integer, List<String>> selectMap) {
        if (selectMap == null || selectMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<Integer, List<String>>> entrySet = selectMap.entrySet();
        for (Map.Entry<Integer, List<String>> entry : entrySet) {
            int y = entry.getKey();
            List<String> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            String[] arr = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = list.get(i);
            }
            DataValidationHelper helper = sheet.getDataValidationHelper();
            CellRangeAddressList addressList = new CellRangeAddressList(1, 65000, y, y);
            DataValidationConstraint dvc = helper.createExplicitListConstraint(arr);
            DataValidation dv = helper.createValidation(dvc, addressList);
            if (dv instanceof HSSFDataValidation) {
                dv.setSuppressDropDownArrow(false);
            } else {
                dv.setSuppressDropDownArrow(true);
                dv.setShowErrorBox(true);
            }
            sheet.addValidationData(dv);
        }
    }

    private static boolean isNumeric(String str) {
        if (Objects.nonNull(str) && "0.0".equals(str)) {
            return true;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getString(String s) {
        if (s == null) {
            return "";
        }
        if (s.isEmpty()) {
            return s;
        }
        return s.trim();
    }
}

