/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.crud.aop;

import com.cssw.bootx.extension.crud.annotation.CrudApi;
import com.cssw.bootx.extension.crud.controller.AbstractCrudController;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class CrudApiAnnotationInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = AopUtils.getTargetClass((Object)Objects.requireNonNull(invocation.getThis()));
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), (Class)targetClass);
        Method targetMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        CrudApi crudApi = (CrudApi)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)targetMethod, CrudApi.class);
        AbstractCrudController crudController = (AbstractCrudController)invocation.getThis();
        crudController.preHandle(crudApi, invocation.getArguments(), targetMethod, targetClass);
        return invocation.proceed();
    }
}

