/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.crud.controller;

import cn.hutool.core.lang.tree.Tree;
import com.cssw.bootx.extension.crud.annotation.CrudApi;
import com.cssw.bootx.extension.crud.enums.Api;
import com.cssw.bootx.extension.crud.handler.CrudApiHandler;
import com.cssw.bootx.extension.crud.model.query.PageQuery;
import com.cssw.bootx.extension.crud.model.query.SortQuery;
import com.cssw.bootx.extension.crud.model.req.IdsReq;
import com.cssw.bootx.extension.crud.model.resp.BasePageResp;
import com.cssw.bootx.extension.crud.model.resp.IdResp;
import com.cssw.bootx.extension.crud.model.resp.LabelValueResp;
import com.cssw.bootx.extension.crud.service.CrudService;
import com.cssw.bootx.extension.crud.validation.CrudValidationGroup;
import com.feiniaojin.gracefulresponse.api.ExcludeFromGracefulResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class AbstractCrudController<S extends CrudService<L, D, Q, C>, L, D, Q, C>
implements CrudApiHandler {
    @Autowired
    protected S baseService;

    @CrudApi(value=Api.PAGE)
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u5217\u8868", description="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @ResponseBody
    @GetMapping
    public BasePageResp<L> page(@Valid Q query, @Valid PageQuery pageQuery) {
        return this.baseService.page(query, pageQuery);
    }

    @CrudApi(value=Api.LIST)
    @Operation(summary="\u67e5\u8be2\u5217\u8868", description="\u67e5\u8be2\u5217\u8868")
    @ResponseBody
    @GetMapping(value={"/list"})
    public List<L> list(@Valid Q query, @Valid SortQuery sortQuery) {
        return this.baseService.list(query, sortQuery);
    }

    @CrudApi(value=Api.TREE)
    @Operation(summary="\u67e5\u8be2\u6811\u5217\u8868", description="\u67e5\u8be2\u6811\u5217\u8868")
    @ResponseBody
    @GetMapping(value={"/tree"})
    public List<Tree<Long>> tree(@Valid Q query, @Valid SortQuery sortQuery) {
        return this.baseService.tree(query, sortQuery, false);
    }

    @CrudApi(value=Api.GET)
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    @Parameter(name="id", description="ID", example="1", in=ParameterIn.PATH)
    @ResponseBody
    @GetMapping(value={"/{id}"})
    public D get(@PathVariable(value="id") Long id) {
        return this.baseService.get(id);
    }

    @CrudApi(value=Api.CREATE)
    @Operation(summary="\u521b\u5efa\u6570\u636e", description="\u521b\u5efa\u6570\u636e")
    @ResponseBody
    @PostMapping
    @Validated(value={CrudValidationGroup.Create.class})
    public IdResp<Long> create(@RequestBody @Valid C req) {
        return new IdResp<Long>(this.baseService.create(req));
    }

    @CrudApi(value=Api.UPDATE)
    @Operation(summary="\u4fee\u6539\u6570\u636e", description="\u4fee\u6539\u6570\u636e")
    @Parameter(name="id", description="ID", example="1", in=ParameterIn.PATH)
    @ResponseBody
    @PutMapping(value={"/{id}"})
    @Validated(value={CrudValidationGroup.Update.class})
    public void update(@RequestBody @Valid C req, @PathVariable(value="id") Long id) {
        this.baseService.update(req, id);
    }

    @CrudApi(value=Api.DELETE)
    @Operation(summary="\u5220\u9664\u6570\u636e", description="\u5220\u9664\u6570\u636e")
    @Parameter(name="id", description="ID", example="1", in=ParameterIn.PATH)
    @ResponseBody
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") Long id) {
        this.baseService.delete(List.of(id));
    }

    @CrudApi(value=Api.BATCH_DELETE)
    @Operation(summary="\u6279\u91cf\u5220\u9664\u6570\u636e", description="\u6279\u91cf\u5220\u9664\u6570\u636e")
    @ResponseBody
    @DeleteMapping
    public void batchDelete(@RequestBody @Valid IdsReq req) {
        this.baseService.delete(req.getIds());
    }

    @CrudApi(value=Api.EXPORT)
    @ExcludeFromGracefulResponse
    @Operation(summary="\u5bfc\u51fa\u6570\u636e", description="\u5bfc\u51fa\u6570\u636e")
    @GetMapping(value={"/export"})
    public void export(@Valid Q query, @Valid SortQuery sortQuery, HttpServletResponse response) {
        this.baseService.export(query, sortQuery, response);
    }

    @CrudApi(value=Api.DICT)
    @Operation(summary="\u67e5\u8be2\u5b57\u5178\u5217\u8868", description="\u67e5\u8be2\u5b57\u5178\u5217\u8868\uff08\u4e0b\u62c9\u9009\u9879\u7b49\u573a\u666f\uff09")
    @GetMapping(value={"/dict"})
    public List<LabelValueResp> dict(@Valid Q query, @Valid SortQuery sortQuery) {
        return this.baseService.dict(query, sortQuery);
    }

    @CrudApi(value=Api.TREE_DICT)
    @Operation(summary="\u67e5\u8be2\u6811\u578b\u5b57\u5178\u5217\u8868", description="\u67e5\u8be2\u6811\u578b\u7ed3\u6784\u5b57\u5178\u5217\u8868\uff08\u6811\u578b\u7ed3\u6784\u4e0b\u62c9\u9009\u9879\u7b49\u573a\u666f\uff09")
    @GetMapping(value={"/dict/tree"})
    public List<Tree<Long>> treeDict(@Valid Q query, @Valid SortQuery sortQuery) {
        return this.baseService.tree(query, sortQuery, true);
    }
}

