/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.context;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.cssw.bootx.core.util.SpringUtils;
import com.cssw.bootx.extension.tenant.autoconfigure.TenantProperties;
import com.cssw.bootx.extension.tenant.config.TenantDataSource;
import com.cssw.bootx.extension.tenant.context.TenantContext;
import com.cssw.bootx.extension.tenant.enums.TenantIsolationLevel;
import java.util.Optional;
import lombok.Generated;

public class TenantContextHolder {
    private static final TransmittableThreadLocal<TenantContext> CONTEXT_HOLDER = new TransmittableThreadLocal();
    private static final TransmittableThreadLocal<Boolean> IGNORE_HOLDER = new TransmittableThreadLocal();

    public static void setContext(TenantContext context) {
        CONTEXT_HOLDER.set((Object)context);
    }

    public static TenantContext getContext() {
        return (TenantContext)CONTEXT_HOLDER.get();
    }

    public static void setIgnore(boolean ignore) {
        IGNORE_HOLDER.set((Object)ignore);
    }

    public static boolean isIgnore() {
        return Boolean.TRUE.equals(IGNORE_HOLDER.get());
    }

    public static void clear() {
        CONTEXT_HOLDER.remove();
        IGNORE_HOLDER.remove();
    }

    public static Long getTenantId() {
        return Optional.ofNullable(TenantContextHolder.getContext()).map(TenantContext::getTenantId).orElse(null);
    }

    public static TenantIsolationLevel getIsolationLevel() {
        return Optional.ofNullable(TenantContextHolder.getContext()).map(TenantContext::getIsolationLevel).orElse(((TenantProperties)SpringUtil.getBean(TenantProperties.class)).getIsolationLevel());
    }

    public static TenantDataSource getDataSource() {
        return Optional.ofNullable(TenantContextHolder.getContext()).map(TenantContext::getDataSource).orElse(null);
    }

    public static boolean isTenantEnabled() {
        TenantProperties tenantProperties = (TenantProperties)SpringUtils.getBean(TenantProperties.class, (boolean)true);
        return tenantProperties != null && tenantProperties.isEnabled();
    }

    public static boolean isTenantDisabled() {
        return !TenantContextHolder.isTenantEnabled();
    }

    @Generated
    private TenantContextHolder() {
    }
}

