/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.interceptor;

import cn.hutool.core.annotation.AnnotationUtil;
import com.cssw.bootx.extension.tenant.annotation.TenantIgnore;
import com.cssw.bootx.extension.tenant.autoconfigure.TenantProperties;
import com.cssw.bootx.extension.tenant.config.TenantProvider;
import com.cssw.bootx.extension.tenant.context.TenantContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import lombok.Generated;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class TenantInterceptor
implements HandlerInterceptor {
    private final TenantProperties tenantProperties;
    private final TenantProvider tenantProvider;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = request.getHeader(this.tenantProperties.getTenantIdHeader());
        TenantContextHolder.setContext(this.tenantProvider.getByTenantId(tenantId, true));
        TenantContextHolder.setIgnore(this.isIgnore(handler));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        TenantContextHolder.clear();
    }

    private boolean isIgnore(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            TenantIgnore methodAnnotation = (TenantIgnore)handlerMethod.getMethodAnnotation(TenantIgnore.class);
            if (methodAnnotation != null) {
                return true;
            }
            return AnnotationUtil.getAnnotation((AnnotatedElement)handlerMethod.getBeanType(), TenantIgnore.class) != null;
        }
        return false;
    }

    @Generated
    public TenantInterceptor(TenantProperties tenantProperties, TenantProvider tenantProvider) {
        this.tenantProperties = tenantProperties;
        this.tenantProvider = tenantProvider;
    }
}

