/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.util;

import cn.hutool.extra.spring.SpringUtil;
import com.cssw.bootx.extension.tenant.TenantDataSourceHandler;
import com.cssw.bootx.extension.tenant.config.TenantProvider;
import com.cssw.bootx.extension.tenant.context.TenantContext;
import com.cssw.bootx.extension.tenant.context.TenantContextHolder;
import com.cssw.bootx.extension.tenant.enums.TenantIsolationLevel;
import lombok.Generated;

public class TenantUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Long tenantId, Runnable runnable) {
        if (TenantContextHolder.isTenantDisabled()) {
            runnable.run();
            return;
        }
        TenantContext oldContext = TenantContextHolder.getContext();
        boolean oldIgnore = TenantContextHolder.isIgnore();
        boolean isPush = false;
        try {
            TenantContext newContext = ((TenantProvider)SpringUtil.getBean(TenantProvider.class)).getByTenantId(tenantId.toString(), false);
            TenantContextHolder.setContext(newContext);
            TenantContextHolder.setIgnore(false);
            if (TenantIsolationLevel.DATASOURCE.equals((Object)newContext.getIsolationLevel())) {
                ((TenantDataSourceHandler)SpringUtil.getBean(TenantDataSourceHandler.class)).changeDataSource(newContext.getDataSource());
                isPush = true;
            }
            runnable.run();
        }
        finally {
            TenantContextHolder.setContext(oldContext);
            TenantContextHolder.setIgnore(oldIgnore);
            if (isPush) {
                ((TenantDataSourceHandler)SpringUtil.getBean(TenantDataSourceHandler.class)).poll();
            }
        }
    }

    public static void executeIgnore(Runnable runnable) {
        if (TenantContextHolder.isTenantDisabled() || TenantContextHolder.isIgnore()) {
            runnable.run();
            return;
        }
        try {
            TenantContextHolder.setIgnore(true);
            runnable.run();
        }
        finally {
            TenantContextHolder.setIgnore(false);
        }
    }

    @Generated
    private TenantUtils() {
    }
}

