/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.autoconfigure;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.cssw.bootx.extension.tenant.TenantDataSourceHandler;
import com.cssw.bootx.extension.tenant.annotation.ConditionalOnEnabledTenant;
import com.cssw.bootx.extension.tenant.aop.TenantIgnoreAspect;
import com.cssw.bootx.extension.tenant.autoconfigure.TenantProperties;
import com.cssw.bootx.extension.tenant.config.TenantProvider;
import com.cssw.bootx.extension.tenant.handler.datasource.DefaultTenantDataSourceHandler;
import com.cssw.bootx.extension.tenant.handler.datasource.TenantDataSourceAdvisor;
import com.cssw.bootx.extension.tenant.handler.datasource.TenantDataSourceInterceptor;
import com.cssw.bootx.extension.tenant.handler.line.DefaultTenantLineHandler;
import jakarta.annotation.PostConstruct;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;

@ConditionalOnEnabledTenant
@AutoConfiguration
public class TenantAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAutoConfiguration.class);
    private final TenantProperties tenantProperties;

    @Bean
    @ConditionalOnMissingBean
    public TenantIgnoreAspect tenantIgnoreAspect() {
        return new TenantIgnoreAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        return new TenantLineInnerInterceptor(tenantLineHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantLineHandler tenantLineHandler() {
        return new DefaultTenantLineHandler(this.tenantProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceAdvisor tenantDataSourceAdvisor(TenantDataSourceInterceptor tenantDataSourceInterceptor) {
        return new TenantDataSourceAdvisor(tenantDataSourceInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceInterceptor tenantDataSourceInterceptor(TenantDataSourceHandler tenantDataSourceHandler) {
        return new TenantDataSourceInterceptor(tenantDataSourceHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceHandler tenantDataSourceHandler(DataSource dataSource) {
        return new DefaultTenantDataSourceHandler(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantProvider tenantProvider() {
        if (log.isErrorEnabled()) {
            log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(TenantProvider.class));
        }
        throw new NoSuchBeanDefinitionException(TenantProvider.class);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Tenant' completed initialization.");
    }

    @Generated
    public TenantAutoConfiguration(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

