/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.handler.datasource;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.cssw.bootx.extension.tenant.TenantDataSourceHandler;
import com.cssw.bootx.extension.tenant.context.TenantContextHolder;
import com.cssw.bootx.extension.tenant.enums.TenantIsolationLevel;
import jakarta.annotation.Nonnull;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TenantDataSourceInterceptor
implements MethodInterceptor {
    private final TenantDataSourceHandler tenantDataSourceHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        if (TenantContextHolder.isIgnore()) {
            return invocation.proceed();
        }
        if (TenantIsolationLevel.LINE.equals((Object)TenantContextHolder.getIsolationLevel())) {
            return invocation.proceed();
        }
        boolean isPush = false;
        try {
            this.tenantDataSourceHandler.changeDataSource(TenantContextHolder.getDataSource());
            isPush = true;
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (isPush) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }

    @Generated
    public TenantDataSourceInterceptor(TenantDataSourceHandler tenantDataSourceHandler) {
        this.tenantDataSourceHandler = tenantDataSourceHandler;
    }
}

