/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.idempotent.aop;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.cache.redisson.util.RedisUtils;
import com.cssw.bootx.core.util.expression.ExpressionUtils;
import com.cssw.bootx.idempotent.annotation.Idempotent;
import com.cssw.bootx.idempotent.autoconfigure.IdempotentProperties;
import com.cssw.bootx.idempotent.exception.IdempotentException;
import com.cssw.bootx.idempotent.generator.IdempotentNameGenerator;
import java.lang.reflect.Method;
import java.time.Duration;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class IdempotentAspect {
    private final IdempotentProperties properties;
    private final IdempotentNameGenerator nameGenerator;

    @Around(value="@annotation(idempotent)")
    public Object around(ProceedingJoinPoint joinPoint, Idempotent idempotent) throws Throwable {
        String cacheKey = this.getCacheKey(joinPoint, idempotent);
        if (!RedisUtils.setIfAbsent((String)cacheKey, (Object)cacheKey, (Duration)Duration.ofMillis(idempotent.unit().toMillis(idempotent.timeout())))) {
            throw new IdempotentException(idempotent.message());
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable e) {
            RedisUtils.delete((String)cacheKey);
            throw e;
        }
    }

    private String getCacheKey(ProceedingJoinPoint joinPoint, Idempotent idempotent) {
        String key;
        Object target = joinPoint.getTarget();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        String name = idempotent.name();
        if (CharSequenceUtil.isBlank((CharSequence)name)) {
            name = this.nameGenerator.generate(target, method, args);
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)(key = idempotent.key()))) {
            Object eval = ExpressionUtils.eval((String)key, (Object)target, (Method)method, (Object[])args);
            if (eval == null) {
                throw new IdempotentException("\u5e42\u7b49 Key \u89e3\u6790\u9519\u8bef");
            }
            key = Convert.toStr((Object)eval);
        }
        return RedisUtils.formatKey((String[])new String[]{this.properties.getKeyPrefix(), name, key});
    }

    @Generated
    public IdempotentAspect(IdempotentProperties properties, IdempotentNameGenerator nameGenerator) {
        this.properties = properties;
        this.nameGenerator = nameGenerator;
    }
}

