/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.license.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.cssw.bootx.core.util.CollUtils;
import com.cssw.bootx.license.exception.LicenseException;
import com.cssw.bootx.license.model.LicenseExtraModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerInfoUtils.class);

    public static LicenseExtraModel getServerInfos() {
        LicenseExtraModel result = new LicenseExtraModel();
        try {
            ServerInfoUtils.initServerInfos();
            result.setIpAddress(ServerInfosContainer.ipAddress);
            result.setMacAddress(ServerInfosContainer.macAddress);
            result.setCpuSerial(ServerInfosContainer.cpuSerial);
            result.setMainBoardSerial(ServerInfosContainer.mainBoardSerial);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new LicenseException(String.format("\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f\u5f02\u5e38, %s", e.getMessage()));
        }
        return result;
    }

    private static void initServerInfos() throws Exception {
        if (ServerInfosContainer.ipAddress == null) {
            ServerInfosContainer.ipAddress = ServerInfoUtils.getIpAddress();
        }
        if (ServerInfosContainer.macAddress == null) {
            ServerInfosContainer.macAddress = ServerInfoUtils.getMacAddress();
        }
        if (ServerInfosContainer.cpuSerial == null) {
            ServerInfosContainer.cpuSerial = ServerInfoUtils.getCpuSerial();
        }
        if (ServerInfosContainer.mainBoardSerial == null) {
            ServerInfosContainer.mainBoardSerial = ServerInfoUtils.getMainBoardSerial();
        }
    }

    public static String getServerTempPath() {
        return System.getProperty("user.dir");
    }

    public static String getCpuSerial() {
        return FileUtil.isWindows() ? ServerInfoUtils.getWindowCpuSerial() : ServerInfoUtils.getLinuxCpuSerial();
    }

    public static String getMainBoardSerial() {
        return FileUtil.isWindows() ? ServerInfoUtils.getWindowMainBoardSerial() : ServerInfoUtils.getLinuxMainBoardSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLinuxCpuSerial() {
        String result = "";
        String cpuIdCmd = "dmidecode";
        BufferedReader bufferedReader = null;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", cpuIdCmd});
            bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("uuid");
                if (index < 0) continue;
                result = line.substring(index + "uuid".length() + 1).trim();
                break;
            }
            IoUtil.close((Closeable)bufferedReader);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6Linux cpu\u4fe1\u606f\u9519\u8bef {}", (Object)e.getMessage());
        }
        finally {
            IoUtil.close(bufferedReader);
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWindowCpuSerial() {
        StringBuilder result;
        block6: {
            result = new StringBuilder("");
            File file = null;
            BufferedReader input = null;
            try {
                String line;
                file = File.createTempFile("tmp", ".vbs");
                file.deleteOnExit();
                FileWriter fw = new FileWriter(file);
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery(\"Select * from Win32_Processor\")\n\nFor Each objItem In colItems\n    WScript.Echo objItem.ProcessorId\n    Exit For ' do the first cpu only!\nNext\n";
                fw.write(vbs);
                fw.close();
                Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    result.append(line);
                }
                IoUtil.close((Closeable)input);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6window cpu\u4fe1\u606f\u9519\u8bef, {}", (Object)e.getMessage());
                break block6;
            }
            finally {
                IoUtil.close(input);
                FileUtil.del((File)file);
            }
            FileUtil.del((File)file);
        }
        return result.toString().trim();
    }

    private static String getLinuxMainBoardSerial() {
        String string;
        String command = "dmidecode | grep 'Serial Number' | awk '{print $3}' | tail -1";
        Process process = new ProcessBuilder("sh", "-c", command).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            string = reader.lines().findFirst().orElse("");
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6 Linux \u4e3b\u677f\u5e8f\u5217\u53f7\u5931\u8d25: {}", (Object)e.getMessage());
                return "";
            }
        }
        reader.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWindowMainBoardSerial() {
        StringBuilder result;
        block6: {
            result = new StringBuilder("");
            File file = null;
            BufferedReader input = null;
            try {
                String line;
                file = File.createTempFile("realhowto", ".vbs");
                file.deleteOnExit();
                FileWriter fw = new FileWriter(file);
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _\n   (\"Select * from Win32_BaseBoard\")\nFor Each objItem in colItems\n    Wscript.Echo objItem.SerialNumber\n    exit for  ' do the first cpu only!\nNext\n";
                fw.write(vbs);
                fw.close();
                Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    result.append(line);
                }
                IoUtil.close((Closeable)input);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6Window\u4e3b\u677f\u4fe1\u606f\u9519\u8bef {}", (Object)e.getMessage());
                break block6;
            }
            finally {
                IoUtil.close(input);
                FileUtil.del((File)file);
            }
            FileUtil.del((File)file);
        }
        return result.toString().trim();
    }

    public static Set<String> getMacAddress() throws Exception {
        Set<InetAddress> inetAddresses = ServerInfoUtils.getLocalAllInetAddress();
        if (CollectionUtil.isNotEmpty(inetAddresses)) {
            return CollUtils.mapToSet(inetAddresses, ServerInfoUtils::getMacByInetAddress);
        }
        return Collections.emptySet();
    }

    public static Set<String> getIpAddress() throws Exception {
        Set<InetAddress> inetAddresses = ServerInfoUtils.getLocalAllInetAddress();
        if (CollectionUtil.isNotEmpty(inetAddresses)) {
            return CollUtils.mapToSet(inetAddresses, InetAddress::getHostAddress);
        }
        return Collections.emptySet();
    }

    private static String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i != 0) {
                    stringBuilder.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuilder.append("0").append(temp);
                    continue;
                }
                stringBuilder.append(temp);
            }
            return stringBuilder.toString().toUpperCase();
        }
        catch (SocketException e) {
            log.error("getMacByInetAddress {}", (Object)e.getMessage());
            return null;
        }
    }

    private static Set<InetAddress> getLocalAllInetAddress() throws Exception {
        HashSet result = CollUtil.newHashSet((Object[])new InetAddress[0]);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isMulticastAddress()) continue;
                result.add(address);
            }
        }
        return result;
    }

    @Generated
    private ServerInfoUtils() {
    }

    private static class ServerInfosContainer {
        private static Set<String> ipAddress = null;
        private static Set<String> macAddress = null;
        private static String cpuSerial = null;
        private static String mainBoardSerial = null;

        private ServerInfosContainer() {
        }
    }
}

