/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.model;

import com.cssw.bootx.log.enums.Include;
import com.cssw.bootx.log.model.LogRequest;
import com.cssw.bootx.log.model.LogResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import lombok.Generated;

public class LogRecord {
    private String description;
    private String module;
    private LogRequest request;
    private LogResponse response;
    private Duration timeTaken;
    private final Instant timestamp;
    private String errorMsg;

    public LogRecord(Instant timestamp, LogRequest request, LogResponse response, Duration timeTaken) {
        this.timestamp = timestamp;
        this.request = request;
        this.response = response;
        this.timeTaken = timeTaken;
    }

    public static Started start() {
        return LogRecord.start(Instant.now());
    }

    public static Started start(Instant timestamp) {
        return new Started(timestamp);
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setRequest(LogRequest request) {
        this.request = request;
    }

    @Generated
    public void setResponse(LogResponse response) {
        this.response = response;
    }

    @Generated
    public void setTimeTaken(Duration timeTaken) {
        this.timeTaken = timeTaken;
    }

    @Generated
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public LogRequest getRequest() {
        return this.request;
    }

    @Generated
    public LogResponse getResponse() {
        return this.response;
    }

    @Generated
    public Duration getTimeTaken() {
        return this.timeTaken;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public static final class Started {
        private final Instant timestamp;

        private Started(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public LogRecord finish(Instant timestamp, Set<Include> includes) {
            LogRequest logRequest = new LogRequest(includes);
            LogResponse logResponse = new LogResponse(includes);
            Duration duration = Duration.between(this.timestamp, timestamp);
            return new LogRecord(this.timestamp, logRequest, logResponse, duration);
        }
    }
}

