/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.model;

import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.core.util.ExceptionUtils;
import com.cssw.bootx.core.util.IpUtils;
import com.cssw.bootx.core.util.ServletUtils;
import com.cssw.bootx.log.enums.Include;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class LogRequest {
    private String method = ServletUtils.getRequestMethod();
    private URI url = ServletUtils.getRequestUrl();
    private String ip = ServletUtils.getRequestIp();
    private Map<String, String> headers;
    private String body;
    private Map<String, Object> param;
    private String address;
    private String browser;
    private String os;

    public LogRequest(Set<Include> includes) {
        Map map = this.headers = includes.contains((Object)Include.REQUEST_HEADERS) ? ServletUtils.getRequestHeaders() : null;
        if (includes.contains((Object)Include.REQUEST_BODY)) {
            this.body = ServletUtils.getRequestBody();
        } else if (includes.contains((Object)Include.REQUEST_PARAM)) {
            this.param = ServletUtils.getRequestParams();
        }
        String string = this.address = includes.contains((Object)Include.IP_ADDRESS) ? (String)ExceptionUtils.exToNull(() -> IpUtils.getIpv4Address((String)this.ip)) : null;
        if (this.headers == null) {
            return;
        }
        String userAgentString = this.headers.entrySet().stream().filter(h -> "User-Agent".equalsIgnoreCase((String)h.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
        if (CharSequenceUtil.isNotBlank((CharSequence)userAgentString)) {
            this.browser = includes.contains((Object)Include.BROWSER) ? ServletUtils.getBrowser((String)userAgentString) : null;
            this.os = includes.contains((Object)Include.OS) ? ServletUtils.getOs((String)userAgentString) : null;
        }
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setUrl(URI url) {
        this.url = url;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setBrowser(String browser) {
        this.browser = browser;
    }

    @Generated
    public void setOs(String os) {
        this.os = os;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public URI getUrl() {
        return this.url;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public Map<String, Object> getParam() {
        return this.param;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getBrowser() {
        return this.browser;
    }

    @Generated
    public String getOs() {
        return this.os;
    }
}

