/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.messaging.mail.autoconfigure;

import cn.hutool.core.map.MapUtil;
import com.cssw.bootx.core.util.MapUtils;
import com.cssw.bootx.core.yaml.YamlPropertySourceFactory;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@AutoConfiguration
@EnableConfigurationProperties(value={MailProperties.class})
@PropertySource(value={"classpath:default-messaging-mail.yml"}, factory=YamlPropertySourceFactory.class)
public class MailAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailAutoConfiguration.class);

    @Bean
    JavaMailSenderImpl mailSender(MailProperties properties) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        this.applyProperties(properties, sender);
        return sender;
    }

    private void applyProperties(MailProperties properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        sender.setProtocol(properties.getProtocol());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (MapUtil.isNotEmpty((Map)properties.getProperties())) {
            sender.setJavaMailProperties(MapUtils.toProperties((Map)properties.getProperties()));
        }
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Mail' completed initialization.");
    }
}

