/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.messaging.mail.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.cssw.bootx.core.util.ExceptionUtils;
import com.cssw.bootx.messaging.mail.core.MailConfigurer;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailUtils {
    public static void sendText(String to, String subject, String content) throws MessagingException {
        MailUtils.send(MailUtils.splitAddress(to), null, null, subject, content, false, new File[0]);
    }

    public static void sendHtml(String to, String subject, String content) throws MessagingException {
        MailUtils.send(MailUtils.splitAddress(to), null, null, subject, content, true, new File[0]);
    }

    public static void sendHtml(String to, String subject, String content, File ... files) throws MessagingException {
        MailUtils.send(MailUtils.splitAddress(to), null, null, subject, content, true, files);
    }

    public static void sendHtml(Collection<String> tos, String subject, String content, File ... files) throws MessagingException {
        MailUtils.send(tos, null, null, subject, content, true, files);
    }

    public static void sendHtml(Collection<String> tos, Collection<String> ccs, String subject, String content, File ... files) throws MessagingException {
        MailUtils.send(tos, ccs, null, subject, content, true, files);
    }

    public static void sendHtml(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, File ... files) throws MessagingException {
        MailUtils.send(tos, ccs, bccs, subject, content, true, files);
    }

    public static void send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) throws MessagingException {
        Assert.isFalse((boolean)CollUtil.isEmpty(tos), (String)"\u8bf7\u81f3\u5c11\u6307\u5b9a\u4e00\u540d\u6536\u4ef6\u4eba", (Object[])new Object[0]);
        JavaMailSenderImpl mailSender = MailUtils.getMailSender();
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.displayName());
        messageHelper.setFrom(CharSequenceUtil.blankToDefault((CharSequence)mailSender.getJavaMailProperties().getProperty("mail.from"), (String)mailSender.getUsername()));
        messageHelper.setSubject(subject);
        messageHelper.setText(content, isHtml);
        if (CollUtil.isNotEmpty(ccs)) {
            messageHelper.setCc((String[])ccs.toArray(String[]::new));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            messageHelper.setBcc((String[])bccs.toArray(String[]::new));
        }
        messageHelper.setTo((String[])tos.toArray(String[]::new));
        if (ArrayUtil.isNotEmpty((Object[])files)) {
            for (File file : files) {
                messageHelper.addAttachment(file.getName(), file);
            }
        }
        mailSender.send(mimeMessage);
    }

    private static List<String> splitAddress(String addresses) {
        if (CharSequenceUtil.isBlank((CharSequence)addresses)) {
            return new ArrayList<String>(0);
        }
        List result = CharSequenceUtil.contains((CharSequence)addresses, (CharSequence)",") ? CharSequenceUtil.splitTrim((CharSequence)addresses, (CharSequence)",") : (CharSequenceUtil.contains((CharSequence)addresses, (CharSequence)";") ? CharSequenceUtil.splitTrim((CharSequence)addresses, (CharSequence)";") : CollUtil.newArrayList((Object[])new String[]{addresses}));
        return result;
    }

    public static JavaMailSenderImpl getMailSender() {
        JavaMailSenderImpl mailSender = (JavaMailSenderImpl)SpringUtil.getBean(JavaMailSenderImpl.class);
        MailConfigurer mailConfigurer = (MailConfigurer)ExceptionUtils.exToNull(() -> (MailConfigurer)SpringUtil.getBean(MailConfigurer.class));
        if (mailConfigurer != null && mailConfigurer.getMailConfig() != null) {
            mailConfigurer.apply(mailConfigurer.getMailConfig(), mailSender);
        }
        return mailSender;
    }

    @Generated
    private MailUtils() {
    }
}

