/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.messaging.websocket.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.cssw.bootx.messaging.websocket.dao.WebSocketSessionDao;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketUtils.class);
    private static final WebSocketSessionDao SESSION_DAO = (WebSocketSessionDao)SpringUtil.getBean(WebSocketSessionDao.class);

    public static void sendMessage(String clientId, String message) {
        WebSocketSession session = SESSION_DAO.get(clientId);
        WebSocketUtils.sendMessage(session, message);
    }

    public static void sendMessage(WebSocketSession session, String message) {
        WebSocketUtils.sendMessage(session, new TextMessage((CharSequence)message));
    }

    public static void sendMessage(List<String> clientIds, String message) {
        Collection sessionIds = CollUtil.intersection(SESSION_DAO.listAllSessionIds(), clientIds);
        sessionIds.parallelStream().forEach(sessionId -> WebSocketUtils.sendMessage(sessionId, message));
    }

    public static void sendMessage(String message) {
        SESSION_DAO.listAll().forEach(session -> WebSocketUtils.sendMessage(session, message));
    }

    public static void sendMessage(WebSocketSession session, WebSocketMessage<?> message) {
        if (session == null || !session.isOpen()) {
            log.warn("WebSocket session closed.");
            return;
        }
        try {
            session.sendMessage(message);
        }
        catch (IOException e) {
            log.error("WebSocket send message failed. sessionId: {}.", (Object)session.getId(), (Object)e);
        }
    }

    @Generated
    private WebSocketUtils() {
    }
}

