/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.ratelimiter.autoconfigure;

import com.cssw.bootx.cache.redisson.autoconfigure.RedissonAutoConfiguration;
import com.cssw.bootx.ratelimiter.aop.RateLimiterAspect;
import com.cssw.bootx.ratelimiter.autoconfigure.RateLimiterProperties;
import com.cssw.bootx.ratelimiter.generator.DefaultRateLimiterNameGenerator;
import com.cssw.bootx.ratelimiter.generator.RateLimiterNameGenerator;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RedissonAutoConfiguration.class})
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.rate-limiter", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class RateLimiterAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimiterAutoConfiguration.class);

    @Bean
    public RateLimiterAspect rateLimiterAspect(RateLimiterProperties properties, RateLimiterNameGenerator rateLimiterNameGenerator, RedissonClient redissonClient) {
        return new RateLimiterAspect(properties, rateLimiterNameGenerator, redissonClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public RateLimiterNameGenerator nameGenerator() {
        return new DefaultRateLimiterNameGenerator();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'RateLimiter' completed initialization.");
    }
}

