/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.domain.file;

import cn.hutool.json.JSONUtil;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.file.EnhancedMultipartFile;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

public class FileWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWrapper.class);
    private MultipartFile multipartFile;
    private byte[] bytes;
    private InputStream inputStream;
    private String originalFilename;
    private String contentType;
    private long size;

    public static FileWrapper of(MultipartFile file) {
        FileWrapper wrapper = new FileWrapper();
        wrapper.multipartFile = file;
        wrapper.originalFilename = file.getOriginalFilename();
        wrapper.contentType = file.getContentType();
        wrapper.size = file.getSize();
        return wrapper;
    }

    public static FileWrapper of(byte[] bytes, String filename, String contentType) {
        FileWrapper wrapper = FileWrapper.createBaseWrapper(filename, contentType);
        wrapper.bytes = bytes;
        wrapper.size = bytes != null ? (long)bytes.length : 0L;
        return wrapper;
    }

    public static FileWrapper of(InputStream inputStream, String filename, String contentType) {
        FileWrapper wrapper = FileWrapper.createBaseWrapper(filename, contentType);
        wrapper.inputStream = inputStream;
        wrapper.size = -1L;
        return wrapper;
    }

    private static FileWrapper createBaseWrapper(String filename, String contentType) {
        if (filename == null) {
            filename = FileWrapper.tryGetFilenameFromRequest();
        }
        if (contentType == null) {
            contentType = FileWrapper.tryGetContentTypeFromRequest();
        }
        if (filename == null || filename.trim().isEmpty()) {
            throw new StorageException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (contentType == null || contentType.trim().isEmpty()) {
            throw new StorageException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileWrapper wrapper = new FileWrapper();
        wrapper.originalFilename = filename;
        wrapper.contentType = contentType;
        return wrapper;
    }

    private static String tryGetFilenameFromRequest() {
        try {
            HttpServletRequest request;
            String requestContentType;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes && (requestContentType = (request = ((ServletRequestAttributes)requestAttributes).getRequest()).getContentType()) != null && requestContentType.toLowerCase().startsWith("multipart/")) {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    String submittedFilename = part.getSubmittedFileName();
                    if (submittedFilename == null || submittedFilename.trim().isEmpty()) continue;
                    return submittedFilename;
                }
            }
        }
        catch (Exception e) {
            log.debug("\u4ece\u8bf7\u6c42\u4e2d\u83b7\u53d6\u6587\u4ef6\u540d\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static String tryGetContentTypeFromRequest() {
        try {
            HttpServletRequest request;
            String requestContentType;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes && (requestContentType = (request = ((ServletRequestAttributes)requestAttributes).getRequest()).getContentType()) != null && requestContentType.toLowerCase().startsWith("multipart/")) {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    String partContentType;
                    if (part.getSubmittedFileName() == null || (partContentType = part.getContentType()) == null || partContentType.trim().isEmpty()) continue;
                    return partContentType;
                }
            }
        }
        catch (Exception e) {
            log.debug("\u4ece\u8bf7\u6c42\u4e2d\u83b7\u53d6 ContentType \u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static FileWrapper of(Object obj) {
        return FileWrapper.of(obj, null, null);
    }

    public static FileWrapper of(Object obj, String filename, String contentType) {
        if (obj == null) {
            throw new StorageException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (obj instanceof MultipartFile) {
            return FileWrapper.of((MultipartFile)obj);
        }
        if (obj instanceof byte[]) {
            return FileWrapper.of((byte[])obj, filename, contentType);
        }
        if (obj instanceof InputStream) {
            return FileWrapper.of((InputStream)obj, filename, contentType);
        }
        String json = FileWrapper.convertToJson(obj);
        byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
        String finalFilename = filename != null ? filename : "data.json";
        String finalContentType = contentType != null ? contentType : "application/json";
        return FileWrapper.of(jsonBytes, finalFilename, finalContentType);
    }

    public MultipartFile toMultipartFile() {
        if (this.multipartFile != null) {
            return this.multipartFile;
        }
        if (this.bytes != null) {
            return new EnhancedMultipartFile(FileWrapper.getFilenameWithoutExtension(this.originalFilename), this.originalFilename, this.contentType, this.bytes);
        }
        if (this.inputStream != null) {
            try {
                byte[] data = this.inputStream.readAllBytes();
                return new EnhancedMultipartFile(FileWrapper.getFilenameWithoutExtension(this.originalFilename), this.originalFilename, this.contentType, data);
            }
            catch (IOException e) {
                throw new StorageException("\u8bfb\u53d6\u8f93\u5165\u6d41\u5931\u8d25", e);
            }
        }
        throw new IllegalStateException("\u65e0\u6cd5\u8f6c\u6362\u4e3a MultipartFile");
    }

    private static String getFilenameWithoutExtension(String filename) {
        int lastDotIndex = filename.lastIndexOf(46);
        return lastDotIndex > 0 ? filename.substring(0, lastDotIndex) : filename;
    }

    private static String convertToJson(Object obj) {
        try {
            return JSONUtil.toJsonStr((Object)obj);
        }
        catch (Exception e) {
            throw new StorageException("\u5bf9\u8c61\u8f6c\u6362\u4e3a JSON \u5931\u8d25", e);
        }
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.size;
    }

    @Generated
    private FileWrapper() {
    }
}

