/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.preprocess.impl;

import cn.hutool.core.io.FileUtil;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.domain.model.req.ThumbnailInfo;
import com.cssw.bootx.storage.domain.model.req.ThumbnailSize;
import com.cssw.bootx.storage.processor.preprocess.ThumbnailProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class DefaultThumbnailProcessor
implements ThumbnailProcessor {
    @Override
    public String getName() {
        return DefaultThumbnailProcessor.class.getSimpleName();
    }

    @Override
    public boolean support(UploadContext context) {
        String contentType = context.getFile().getContentType();
        return contentType != null && contentType.startsWith("image/");
    }

    @Override
    public ThumbnailInfo process(UploadContext context, InputStream sourceInputStream) {
        try {
            String suffix = FileUtil.getSuffix((String)context.getFormatFileName());
            ThumbnailSize size = context.getThumbnailSize();
            BufferedImage thumbnail = Thumbnails.of((InputStream[])new InputStream[]{sourceInputStream}).size(size.getWidth(), size.getHeight()).keepAspectRatio(size.isKeepAspectRatio()).asBufferedImage();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)thumbnail, suffix, baos);
            ThumbnailInfo info = new ThumbnailInfo();
            info.setData(baos.toByteArray());
            info.setFormat(suffix);
            info.setWidth(thumbnail.getWidth());
            info.setHeight(thumbnail.getHeight());
            return info;
        }
        catch (Exception e) {
            throw new StorageException("\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25", e);
        }
    }
}

