/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.preprocess.impl;

import cn.hutool.core.io.FileUtil;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.processor.preprocess.FileValidator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FileTypeValidator
implements FileValidator {
    private final Set<String> allowedExtensions;

    public FileTypeValidator() {
        this.allowedExtensions = null;
    }

    public FileTypeValidator(String ... extensions) {
        this.allowedExtensions = new HashSet<String>(Arrays.asList(extensions));
    }

    @Override
    public String getName() {
        return FileTypeValidator.class.getSimpleName();
    }

    @Override
    public boolean support(UploadContext context) {
        return true;
    }

    @Override
    public void validate(UploadContext context) throws StorageException {
        String filename = context.getFile().getOriginalFilename();
        if (filename != null) {
            String extension = FileUtil.extName((String)filename).toLowerCase();
            if (this.allowedExtensions != null && !this.allowedExtensions.contains(extension)) {
                throw new StorageException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b: " + extension + "\uff0c\u4ec5\u652f\u6301: " + String.join((CharSequence)", ", this.allowedExtensions));
            }
        }
    }
}

