/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.progress;

import com.cssw.bootx.storage.processor.progress.ProgressTracker;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private final ProgressTracker tracker;

    public ProgressInputStream(InputStream in, ProgressTracker tracker) {
        super(in);
        this.tracker = tracker;
        tracker.start();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            this.tracker.updateProgress(1L);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this.tracker.updateProgress(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.tracker.complete();
    }
}

