/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.progress;

import com.cssw.bootx.storage.processor.progress.UploadProgressListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ProgressTracker {
    private final long totalBytes;
    private final UploadProgressListener listener;
    private final AtomicLong bytesRead = new AtomicLong(0L);
    private final AtomicLong lastNotifiedBytes = new AtomicLong(0L);
    private final AtomicInteger lastPercentage = new AtomicInteger(-1);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private static final int PERCENTAGE_THRESHOLD = 1;
    private static final long BYTES_THRESHOLD = 0x100000L;

    public ProgressTracker(long totalBytes, UploadProgressListener listener) {
        this.totalBytes = totalBytes;
        this.listener = listener;
    }

    public void start() {
        if (this.started.compareAndSet(false, true) && this.listener != null) {
            this.listener.onStart();
        }
    }

    public void updateProgress(long bytes) {
        if (this.completed.get() || this.listener == null) {
            return;
        }
        long currentBytes = this.bytesRead.addAndGet(bytes);
        int currentPercentage = this.totalBytes > 0L ? (int)(currentBytes * 100L / this.totalBytes) : -1;
        boolean shouldNotify = false;
        int lastPct = this.lastPercentage.get();
        if (currentPercentage >= 0) {
            if (currentPercentage - lastPct >= 1) {
                shouldNotify = true;
            }
            if (currentPercentage == 100 && lastPct != 100) {
                shouldNotify = true;
            }
        }
        if (currentBytes - this.lastNotifiedBytes.get() >= 0x100000L) {
            shouldNotify = true;
        }
        if (shouldNotify && this.lastPercentage.compareAndSet(lastPct, currentPercentage)) {
            this.lastNotifiedBytes.set(currentBytes);
            this.listener.onProgress(currentBytes, this.totalBytes, currentPercentage);
            if (currentPercentage == 100) {
                this.complete();
            }
        }
    }

    public void complete() {
        if (this.completed.compareAndSet(false, true) && this.listener != null) {
            this.listener.onComplete();
        }
    }

    public void error(Exception e) {
        if (this.listener != null) {
            this.listener.onError(e);
        }
    }
}

