/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.registry;

import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.processor.preprocess.FileNameGenerator;
import com.cssw.bootx.storage.processor.preprocess.FilePathGenerator;
import com.cssw.bootx.storage.processor.preprocess.FileValidator;
import com.cssw.bootx.storage.processor.preprocess.ThumbnailProcessor;
import com.cssw.bootx.storage.processor.preprocess.UploadCompleteProcessor;
import com.cssw.bootx.storage.service.FileProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProcessorRegistry {
    private final Map<Class<?>, List<FileProcessor>> processors = new ConcurrentHashMap();
    private final Map<String, Map<Class<?>, List<FileProcessor>>> platformProcessors = new ConcurrentHashMap();

    public void register(FileProcessor processor) {
        this.register(processor, null);
    }

    public void register(FileProcessor processor, String platform) {
        Class<?> type = this.getProcessorType(processor);
        if (platform == null) {
            this.processors.computeIfAbsent(type, k -> new CopyOnWriteArrayList()).add(processor);
        } else {
            this.platformProcessors.computeIfAbsent(platform, k -> new ConcurrentHashMap()).computeIfAbsent(type, k -> new CopyOnWriteArrayList()).add(processor);
        }
    }

    private Class<?> getProcessorType(FileProcessor processor) {
        if (processor instanceof ThumbnailProcessor) {
            return ThumbnailProcessor.class;
        }
        if (processor instanceof FileValidator) {
            return FileValidator.class;
        }
        if (processor instanceof FileNameGenerator) {
            return FileNameGenerator.class;
        }
        if (processor instanceof FilePathGenerator) {
            return FilePathGenerator.class;
        }
        if (processor instanceof UploadCompleteProcessor) {
            return UploadCompleteProcessor.class;
        }
        return FileProcessor.class;
    }

    public <T extends FileProcessor> List<T> getProcessors(Class<T> type, String platform, UploadContext context) {
        List<FileProcessor> platformList;
        Map<Class<?>, List<FileProcessor>> platformMap;
        ArrayList<FileProcessor> result = new ArrayList<FileProcessor>();
        List<FileProcessor> globalList = this.processors.get(type);
        if (globalList != null) {
            globalList.stream().filter(p -> p.support(context)).map(p -> p).forEach(result::add);
        }
        if (platform != null && (platformMap = this.platformProcessors.get(platform)) != null && (platformList = platformMap.get(type)) != null) {
            platformList.stream().filter(p -> p.support(context)).map(p -> p).forEach(result::add);
        }
        result.sort(Comparator.comparingInt(FileProcessor::getOrder).reversed());
        return result;
    }

    public <T extends FileProcessor> T getProcessor(Class<T> type, String platform, UploadContext context) {
        List<T> processors = this.getProcessors(type, platform, context);
        return (T)(processors.isEmpty() ? null : (FileProcessor)processors.get(0));
    }
}

