/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.strategy.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.URLUtil;
import com.cssw.bootx.core.util.SpringWebUtils;
import com.cssw.bootx.storage.autoconfigure.properties.LocalStorageProperties;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.model.resp.FileInfo;
import com.cssw.bootx.storage.domain.model.resp.MultipartInitResp;
import com.cssw.bootx.storage.domain.model.resp.MultipartUploadResp;
import com.cssw.bootx.storage.strategy.StorageStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class LocalStorageStrategy
implements StorageStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalStorageStrategy.class);
    private final LocalStorageProperties config;
    private final String TEMP_DIR = ".multipart";

    public LocalStorageStrategy(LocalStorageProperties config) {
        this.config = config;
        this.initTempDir(config.getBucketName());
        this.registerResources(config);
    }

    public void registerResources(LocalStorageProperties config) {
        SpringWebUtils.registerResourceHandler((Map)MapUtil.of((Object)URLUtil.url((String)config.getEndpoint()).getPath(), (Object)config.getBucketName()));
    }

    private void initTempDir(String bucket) {
        Path tempPath = Paths.get(bucket, ".multipart");
        try {
            Files.createDirectories(tempPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u4e34\u65f6\u76ee\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void upload(String bucket, String path, MultipartFile file) {
        Path filePath = Paths.get(bucket, path);
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream download(String bucket, String path) {
        Path filePath = Paths.get(bucket, path);
        try {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new StorageException("\u672c\u5730\u8bfb\u53d6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream batchDownload(String bucket, List<String> paths) {
        return null;
    }

    @Override
    public void delete(String bucket, String path) {
        Path filePath = Paths.get(bucket, path);
        try {
            Files.deleteIfExists(filePath);
            this.deleteEmptyParentDirectories(filePath.getParent());
        }
        catch (IOException e) {
            throw new StorageException("\u5220\u9664\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void batchDelete(String bucket, List<String> paths) {
    }

    @Override
    public boolean exists(String bucket, String path) {
        Path filePath = Paths.get(bucket, path);
        return Files.exists(filePath, new LinkOption[0]);
    }

    @Override
    public FileInfo getFileInfo(String bucket, String path) {
        Path filePath = Paths.get(bucket, path);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        try {
            BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setBucket(bucket);
            fileInfo.setPlatform(this.config.getPlatform());
            fileInfo.setPath(path);
            fileInfo.setFullPath(filePath.toString());
            fileInfo.setName(filePath.getFileName().toString());
            fileInfo.setSize(attrs.size());
            fileInfo.setUrl(this.config.getEndpoint() + "/" + path);
            fileInfo.setUploadTime(LocalDateTime.ofInstant(attrs.creationTime().toInstant(), ZoneId.systemDefault()));
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("etag", this.calculateMD5(filePath));
            fileInfo.setMetadata(metadata);
            return fileInfo;
        }
        catch (Exception e) {
            throw new StorageException("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public List<FileInfo> list(String bucket, String prefix, int maxKeys) {
        List<FileInfo> list;
        block8: {
            Path basePath = Paths.get(bucket, new String[0]);
            Path searchPath = prefix != null ? basePath.resolve(prefix) : basePath;
            Stream<Path> stream = Files.walk(searchPath, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).limit(maxKeys).map(path -> {
                    String relativePath = basePath.relativize((Path)path).toString();
                    return this.getFileInfo(bucket, relativePath);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException("\u5217\u51fa\u6587\u4ef6\u5931\u8d25: " + e.getMessage(), e);
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    public void copy(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        Path source = Paths.get(sourceBucket, sourcePath);
        Path target = Paths.get(targetBucket, targetPath);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new StorageException("\u590d\u5236\u6587\u4ef6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void move(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
    }

    @Override
    public String getPlatform() {
        return this.config.getPlatform();
    }

    @Override
    public String defaultBucket() {
        return this.config.getBucketName();
    }

    @Override
    public String generatePresignedUrl(String bucket, String path, long expireSeconds) {
        return this.config.getEndpoint() + "/" + path;
    }

    private void deleteEmptyParentDirectories(Path dir) {
        if (dir == null || !dir.startsWith(this.config.getBucketName())) {
            return;
        }
        try {
            if (Files.isDirectory(dir, new LinkOption[0]) && this.isDirectoryEmpty(dir)) {
                Files.delete(dir);
                this.deleteEmptyParentDirectories(dir.getParent());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isDirectoryEmpty(Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }

    @Override
    public MultipartInitResp initMultipartUpload(String bucket, String path, String contentType, Map<String, String> metadata) {
        try {
            String uploadId = UUID.randomUUID().toString();
            Path tempUploadPath = Paths.get(bucket, ".multipart", uploadId);
            Files.createDirectories(tempUploadPath, new FileAttribute[0]);
            MultipartInitResp result = new MultipartInitResp();
            result.setBucket(bucket);
            result.setFileId(UUID.randomUUID().toString());
            result.setUploadId(uploadId);
            result.setPlatform(this.config.getPlatform());
            result.setPath(path);
            result.setPartSize(0x500000L);
            return result;
        }
        catch (Exception e) {
            throw new StorageException("\u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public MultipartUploadResp uploadPart(String bucket, String path, String uploadId, int partNumber, InputStream data) {
        MultipartUploadResp result = new MultipartUploadResp();
        result.setPartNumber(partNumber);
        try {
            Path partPath = Paths.get(bucket, ".multipart", uploadId, String.format("part_%05d", partNumber));
            long size = Files.copy(data, partPath, StandardCopyOption.REPLACE_EXISTING);
            String eTag = this.calculateMD5(partPath);
            result.setPartETag(eTag);
            result.setPartSize(size);
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public FileInfo completeMultipartUpload(String bucket, String path, String uploadId, List<MultipartUploadResp> parts, boolean verifyParts) {
        try {
            Path targetPath = Paths.get(bucket, path);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(targetPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                List<MultipartUploadResp> sortedParts = parts.stream().filter(MultipartUploadResp::isSuccess).sorted(Comparator.comparingInt(MultipartUploadResp::getPartNumber)).toList();
                for (MultipartUploadResp part : sortedParts) {
                    Path partPath = Paths.get(bucket, ".multipart", uploadId, String.format("part_%05d", part.getPartNumber()));
                    if (!Files.exists(partPath, new LinkOption[0])) {
                        throw new StorageException("\u5206\u7247\u6587\u4ef6\u4e0d\u5b58\u5728: part " + part.getPartNumber());
                    }
                    Files.copy(partPath, out);
                }
            }
            this.cleanupTempFiles(bucket, uploadId);
            return this.getFileInfo(bucket, path);
        }
        catch (Exception e) {
            throw new StorageException("\u5b8c\u6210\u5206\u7247\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void abortMultipartUpload(String bucket, String path, String uploadId) {
        try {
            this.cleanupTempFiles(bucket, uploadId);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5206\u7247\u4e0a\u4f20\u5931\u8d25: uploadId={}", (Object)uploadId, (Object)e);
        }
    }

    @Override
    public List<MultipartUploadResp> listParts(String bucket, String path, String uploadId) {
        return new ArrayList<MultipartUploadResp>();
    }

    private void cleanupTempFiles(String bucket, String uploadId) {
        Path tempUploadPath = Paths.get(bucket, ".multipart", uploadId);
        if (Files.exists(tempUploadPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(tempUploadPath, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                log.error("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: uploadId={}", (Object)uploadId, (Object)e);
            }
        }
    }

    private String calculateMD5(Path path) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
        }
        byte[] digest = md.digest();
        return HexFormat.of().formatHex(digest).toLowerCase();
    }

    @Override
    public void cleanup() {
        if (this.config != null) {
            SpringWebUtils.deRegisterResourceHandler((Map)MapUtil.of((Object)URLUtil.url((String)this.config.getEndpoint()).getPath(), (Object)this.config.getBucketName()));
        }
    }
}

