/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.strategy.impl;

import com.cssw.bootx.storage.domain.model.resp.FileInfo;
import com.cssw.bootx.storage.domain.model.resp.MultipartInitResp;
import com.cssw.bootx.storage.domain.model.resp.MultipartUploadResp;
import com.cssw.bootx.storage.strategy.StorageStrategy;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public abstract class StorageStrategyDecorator<T extends StorageStrategy>
implements StorageStrategy {
    protected T delegate;

    public abstract Class<T> getTargetStrategyClass();

    public void setDelegate(T delegate) {
        this.delegate = delegate;
    }

    protected T getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("\u88c5\u9970\u5668\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8bbe\u7f6edelegate");
        }
        return this.delegate;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void upload(String bucket, String path, MultipartFile file) {
        this.getDelegate().upload(bucket, path, file);
    }

    @Override
    public InputStream download(String bucket, String path) {
        return this.getDelegate().download(bucket, path);
    }

    @Override
    public InputStream batchDownload(String bucket, List<String> paths) {
        return this.getDelegate().batchDownload(bucket, paths);
    }

    @Override
    public void delete(String bucket, String path) {
        this.getDelegate().delete(bucket, path);
    }

    @Override
    public void batchDelete(String bucket, List<String> paths) {
        this.getDelegate().batchDelete(bucket, paths);
    }

    @Override
    public boolean exists(String bucket, String path) {
        return this.getDelegate().exists(bucket, path);
    }

    @Override
    public FileInfo getFileInfo(String bucket, String path) {
        return this.getDelegate().getFileInfo(bucket, path);
    }

    @Override
    public List<FileInfo> list(String bucket, String prefix, int maxKeys) {
        return this.getDelegate().list(bucket, prefix, maxKeys);
    }

    @Override
    public void copy(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        this.getDelegate().copy(sourceBucket, targetBucket, sourcePath, targetPath);
    }

    @Override
    public void move(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        this.getDelegate().move(sourceBucket, targetBucket, sourcePath, targetPath);
    }

    @Override
    public String getPlatform() {
        return this.getDelegate().getPlatform();
    }

    @Override
    public String defaultBucket() {
        return this.getDelegate().defaultBucket();
    }

    @Override
    public String generatePresignedUrl(String bucket, String path, long expireSeconds) {
        return this.getDelegate().generatePresignedUrl(bucket, path, expireSeconds);
    }

    @Override
    public MultipartInitResp initMultipartUpload(String bucket, String path, String contentType, Map<String, String> metadata) {
        return this.getDelegate().initMultipartUpload(bucket, path, contentType, metadata);
    }

    @Override
    public MultipartUploadResp uploadPart(String bucket, String path, String uploadId, int partNumber, InputStream data) {
        return this.getDelegate().uploadPart(bucket, path, uploadId, partNumber, data);
    }

    @Override
    public FileInfo completeMultipartUpload(String bucket, String path, String uploadId, List<MultipartUploadResp> parts, boolean verifyParts) {
        return this.getDelegate().completeMultipartUpload(bucket, path, uploadId, parts, verifyParts);
    }

    @Override
    public void abortMultipartUpload(String bucket, String path, String uploadId) {
        this.getDelegate().abortMultipartUpload(bucket, path, uploadId);
    }

    @Override
    public List<MultipartUploadResp> listParts(String bucket, String path, String uploadId) {
        return this.getDelegate().listParts(bucket, path, uploadId);
    }

    @Override
    public void cleanup() {
        this.getDelegate().cleanup();
    }
}

