/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.trace.autoconfigure;

import com.cssw.bootx.trace.autoconfigure.TLogProperties;
import com.cssw.bootx.trace.autoconfigure.TraceProperties;
import com.cssw.bootx.trace.filter.TLogServletFilter;
import com.cssw.bootx.trace.handler.TraceIdGenerator;
import com.yomahub.tlog.id.TLogIdGenerator;
import com.yomahub.tlog.id.TLogIdGeneratorLoader;
import com.yomahub.tlog.spring.TLogPropertyInit;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={TraceProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.trace", name={"enabled"}, havingValue="true")
public class TraceAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceAutoConfiguration.class);
    private final TraceProperties traceProperties;

    @Bean
    @Primary
    public TLogPropertyInit tLogPropertyInit(TLogIdGenerator tLogIdGenerator) {
        TLogProperties tLogProperties = this.traceProperties.getTlog();
        TLogPropertyInit tLogPropertyInit = new TLogPropertyInit();
        tLogPropertyInit.setPattern(tLogProperties.getPattern());
        tLogPropertyInit.setEnableInvokeTimePrint(tLogProperties.getEnableInvokeTimePrint());
        tLogPropertyInit.setMdcEnable(tLogProperties.getMdcEnable());
        TLogIdGeneratorLoader.setIdGenerator((TLogIdGenerator)tLogIdGenerator);
        return tLogPropertyInit;
    }

    @Bean
    public FilterRegistrationBean<TLogServletFilter> tLogServletFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TLogServletFilter(this.traceProperties));
        registrationBean.setOrder(-2147483548);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public TLogIdGenerator tLogIdGenerator() {
        return new TraceIdGenerator();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Trace' completed initialization.");
    }

    @Generated
    public TraceAutoConfiguration(TraceProperties traceProperties) {
        this.traceProperties = traceProperties;
    }
}

