/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.trace.filter;

import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.trace.autoconfigure.TraceProperties;
import com.cssw.bootx.trace.handler.TLogWebCommon;
import com.yomahub.tlog.context.TLogContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;

public class TLogServletFilter
implements Filter {
    private final TraceProperties traceProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                try {
                    TLogWebCommon.loadInstance().preHandle(httpServletRequest);
                    String traceIdName = this.traceProperties.getTraceIdName();
                    if (CharSequenceUtil.isNotBlank((CharSequence)traceIdName)) {
                        httpServletResponse.addHeader(traceIdName, TLogContext.getTraceId());
                    }
                    chain.doFilter(request, response);
                }
                finally {
                    TLogWebCommon.loadInstance().afterCompletion();
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Generated
    public TLogServletFilter(TraceProperties traceProperties) {
        this.traceProperties = traceProperties;
    }
}

