/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.validation.autoconfigure;

import jakarta.annotation.PostConstruct;
import jakarta.validation.Validator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@AutoConfiguration
public class ValidationAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationAutoConfiguration.class);

    @Bean
    public Validator validator(MessageSource messageSource) {
        try (LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();){
            factoryBean.setValidationMessageSource(messageSource);
            factoryBean.getValidationPropertyMap().put("hibernate.validator.fail_fast", Boolean.TRUE.toString());
            factoryBean.afterPropertiesSet();
            Validator validator = factoryBean.getValidator();
            return validator;
        }
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Validation' completed initialization.");
    }
}

